% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalTarget.R
\name{evalTarget}
\alias{evalTarget}
\title{Evaluate multiple target values}
\usage{
evalTarget(values = c(), ...)
}
\arguments{
\item{values}{\code{numeric}. Proportion of maximum value of benefits to verify (both
recovery and conservation benefits). This information can be obtained with
\code{getPotentialBenefit()} function. More than one value is needed.}

\item{...}{arguments inherited from \code{inputData()}, \code{problem()},
and \code{solve()} functions.}
}
\value{
An object of class \linkS4class{portfolio}.
}
\description{
Return one solution per instance for different targets values. This
function assumes that the \emph{minimizeCosts} model is being used. As well as the
\code{prioriactions()} function, it inherits all arguments from \code{inputData()},
\code{problem()} and \code{solve()}.
}
\details{
\code{evalTarget()} creates and solves multiple instances, of the corresponding
multi-actions planning problem, for different proportions of maximum benefit values
as target values. It is assumed that the same proportion is applied for the maximum
benefit in recovery and conservation. Alternatively, this
could be obtained by executing function \code{prioriactions()} or by steps the \code{inputData()},
\code{problem()} and \code{solve()} functions; using, in each run, different targets values.
However, the \code{evalTarget()} function has two advantages with
respect to this manual approach: : 1)
it is more efficient to create the models (this is because the model is created
just once and, at each iteration, only the target values are updated); and 2) the
output is a portfolio object, which allows
obtaining information about the group of solutions (including all \emph{get} functions).
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Create model and solve
port <- evalTarget(pu = sim_pu_data, features = sim_features_data,
                dist_features = sim_dist_features_data,
                threats = sim_threats_data,
                dist_threats = sim_dist_threats_data,
                sensitivity = sim_sensitivity_data,
                boundary = sim_boundary_data,
                values = c(0.1, 0.3, 0.5),
                time_limit = 50,
                output_file = FALSE,
                cores = 2)

getCost(port)
}

}
