% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cuts_portfolio.R
\name{add_cuts_portfolio}
\alias{add_cuts_portfolio}
\alias{add_cuts_portfolio}
\title{Add a Bender's cuts portfolio}
\usage{
add_cuts_portfolio(x, number_solutions = 10L)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{number_solutions}{\code{integer} number of attempts to generate
different solutions. Defaults to 10.}
}
\description{
Generate a portfolio of solutions using Bender's cuts.
}
\details{
This strategy for generating a portfolio of solutions involves
  solving the problem multiple times and adding additional constraints
  to forbid previously obtained solutions. In general, this strategy is most
  useful when problems take a long time to solve and benefit from
  having multiple threads allocated for solving an individual problem.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_relative_targets(0.1) \%>\%
     add_binary_decisions() \%>\%
     add_cuts_portfolio(10) \%>\%
     add_default_solver(gap = 0.2, verbose = FALSE)

\donttest{
# solve problem and generate 10 solutions within 20 \% of optimality
s <- solve(p)

# plot solution
plot(s, axes = FALSE, box = FALSE)
}

}
\seealso{
\code{\link{portfolios}}.
}
