% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category_layer.R
\name{category_layer}
\alias{category_layer}
\title{Category layer}
\usage{
category_layer(x)
}
\arguments{
\item{x}{\code{\link[raster]{Raster-class}} object containing a multiple
layers. Note that pixels must be 0, 1 or \code{NA} values.}
}
\value{
\code{\link[raster]{RasterLayer-class}} object.
}
\description{
Convert a \code{\link[raster]{RasterStack-class}}
object where each layer corresponds to a different identifier and values
indicate the presence/absence of that category into a
\code{\link[raster]{RasterLayer-class}} object containing categorical
identifiers.
}
\details{
This function is provided to help manage data that encompass
  multiple management zones. For instance, this function may be helpful
  for interpreting solutions for problems associated with multiple zones that
  have binary decisions.
}
\examples{
# create a binary raster stack
x <- stack(raster(matrix(c(1, 0, 0, 1, NA, 0), nrow = 3)),
           raster(matrix(c(0, 1, 0, 0, NA, 0), nrow = 3)),
           raster(matrix(c(0, 0, 1, 0, NA, 1), nrow = 3)))

# convert to binary stack
y <- category_layer(x)

# plot categorical raster and binary stack representation
plot(stack(x, y), main = c("x[[1]]", "x[[2]]", "x[[3]]", "y"), nr = 1)

}
\seealso{
\code{\link{binary_stack}}.
}
