% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_names.R
\name{feature_names}
\alias{feature_names}
\alias{feature_names.ConservationProblem}
\alias{feature_names.ZonesRaster}
\alias{feature_names.ZonesSpatRaster}
\alias{feature_names.ZonesCharacter}
\title{Feature names}
\usage{
feature_names(x, ...)

\method{feature_names}{ConservationProblem}(x, ...)

\method{feature_names}{ZonesRaster}(x, ...)

\method{feature_names}{ZonesSpatRaster}(x, ...)

\method{feature_names}{ZonesCharacter}(x, ...)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} or \code{\link[=Zones]{Zones()}} object.}

\item{...}{not used.}
}
\value{
A \code{character} vector of feature names.
}
\description{
Extract the names of the features in an object.
}
\examples{
\dontrun{
# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()

# create problem
p <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.2) \%>\%
  add_binary_decisions()

# print feature names
print(feature_names(p))
}
}
