% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_problem.R
\name{write_problem}
\alias{write_problem}
\title{Write problem}
\usage{
write_problem(x, path, solver = NULL)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{path}{\code{character} file path to save the problem formulation.
The argument should contain a \code{".lp"} or \verb{.mps"} file extension
to specify whether the problem formulation will be saved in the
\href{https://www.gurobi.com/documentation/9.5/refman/lp_format.html}{LP} or
\href{https://www.gurobi.com/documentation/9.5/refman/mps_format.html}{MPS}
format (respectively).}

\item{solver}{\code{character} name of optimization solver to write the problem
to disk. Available options include: \code{"rsymphony" }, \code{"gurobi"}, or \code{NULL}.
Note that using the Gurobi solver is much faster, because the Rsymphony
solver requires attempting to solve the problem before it can be written.
Defaults to \code{NULL}, such that the best available solver is used.}
}
\value{
An invisible \code{TRUE} indicating success.
}
\description{
Save the mathematical formulation for a conservation planning problem
to a file for mixed integer programming solvers. Note that this function
requires either the \pkg{Rsymphony} or \pkg{gurobi} package to be installed.
}
\examples{
\dontrun{
# set seed for reproducibility
set.seed(500)

# load data
sim_pu_polygons <- get_sim_pu_polygons()
sim_features <- get_sim_features()

# subset data to extract first four planning units
sim_pu_polygons <- sim_pu_polygons[1:4, ]

# create minimal problem
p <-
  problem(sim_pu_polygons, sim_features, cost_column = "cost") \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions()

# specify file path to save problem formulation
path <- file.path(tempdir(), "model.lp")
print(path)

# save problem to file
## note that either the gurobi or Rsymphony package needs to be installed
write_problem(p, path)

# print model file
cat(readLines(path), sep = "\n")
}

}
