% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_prism_dailys.R
\name{get_prism_dailys}
\alias{get_prism_dailys}
\title{Download daily prism data}
\usage{
get_prism_dailys(type, minDate = NULL, maxDate = NULL, dates = NULL,
  keepZip = TRUE)
}
\arguments{
\item{type}{The type of data to download, must be "ppt", "tmean", "tmin", "tmax",
which downloads "ppt", "tmin", and "tmax". Note that tmean == mean(tmin, tmax).}

\item{minDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date to start to download data.}

\item{maxDate}{a valid iso-8601 (e.g. YYYY-MM-DD) date to end downloading data.}

\item{dates}{a vector of iso-8601 formatted dates to download data for, can also be a single date.}

\item{keepZip}{if true, leave the downloaded zip files in your 'prism.path', if FALSE, they will be deleted}
}
\description{
Download daily data from the prism project at 4km grid cell resolution for precipitation, mean, min and max temperature
}
\details{
Dates must be in the proper format or downloading will not work properly, you can either enter a date range via minDate and maxDate, or a vector of dates, but not both. You must make sure that you have set up a valid download directory.  This must be set as options(prism.path = "YOURPATH")
# get_prism_dailys(type="tmean", minDate = "2013-06-01", maxDate = "2013-06-14", keepZip=FALSE)
}

