% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-plot-logistic.R
\name{cal_plot_logistic}
\alias{cal_plot_logistic}
\alias{cal_plot_logistic.data.frame}
\alias{cal_plot_logistic.tune_results}
\alias{cal_plot_logistic.grouped_df}
\title{Probability calibration plots via logistic regression}
\usage{
cal_plot_logistic(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  conf_level = 0.9,
  smooth = TRUE,
  include_rug = TRUE,
  include_ribbon = TRUE,
  event_level = c("auto", "first", "second"),
  ...
)

\method{cal_plot_logistic}{data.frame}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  conf_level = 0.9,
  smooth = TRUE,
  include_rug = TRUE,
  include_ribbon = TRUE,
  event_level = c("auto", "first", "second"),
  ...,
  .by = NULL
)

\method{cal_plot_logistic}{tune_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  conf_level = 0.9,
  smooth = TRUE,
  include_rug = TRUE,
  include_ribbon = TRUE,
  event_level = c("auto", "first", "second"),
  ...
)

\method{cal_plot_logistic}{grouped_df}(
  .data,
  truth = NULL,
  estimate = NULL,
  conf_level = 0.9,
  smooth = TRUE,
  include_rug = TRUE,
  include_ribbon = TRUE,
  event_level = c("auto", "first", "second"),
  ...
)
}
\arguments{
\item{.data}{An ungrouped data frame object containing predictions and
probability columns.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{conf_level}{Confidence level to use in the visualization. It defaults
to 0.9.}

\item{smooth}{A logical for using a generalized additive model with smooth
terms for the predictor via \code{\link[mgcv:gam]{mgcv::gam()}} and \code{\link[mgcv:s]{mgcv::s()}}.}

\item{include_rug}{Flag that indicates if the Rug layer is to be included.
It defaults to \code{TRUE}. In the plot, the top side shows the frequency the
event occurring, and the bottom the frequency of the event not occurring.}

\item{include_ribbon}{Flag that indicates if the ribbon layer is to be
included. It defaults to \code{TRUE}.}

\item{event_level}{single string. Either "first" or "second" to specify which
level of truth to consider as the "event". Defaults to "auto", which allows
the function decide which one to use based on the type of model (binary,
multi-class or linear)}

\item{...}{Additional arguments passed to the \code{tune_results} object.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\value{
A ggplot object.
}
\description{
A logistic regression model is fit where the original outcome data are used
as the outcome and the estimated class probabilities for one class are used
as the predictor. If \code{smooth = TRUE}, a generalized additive model is fit
using \code{\link[mgcv:gam]{mgcv::gam()}} and the default smoothing method. Otherwise, a simple
logistic regression is used.

If the predictions are well calibrated, the fitted curve should align with
the diagonal line. Confidence intervals for the fitted line are also
shown.
}
\examples{

library(ggplot2)
library(dplyr)

cal_plot_logistic(
  segment_logistic,
  Class,
  .pred_good
)

cal_plot_logistic(
  segment_logistic,
  Class,
  .pred_good,
  smooth = FALSE
)
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_plot_windowed]{cal_plot_windowed()}}, \code{\link[=cal_plot_breaks]{cal_plot_breaks()}}

\code{\link[=cal_plot_breaks]{cal_plot_breaks()}}, \code{\link[=cal_plot_windowed]{cal_plot_windowed()}}
}
