% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processanimateR.R
\name{animate_process}
\alias{animate_process}
\title{Animate cases on a process map}
\usage{
animate_process(eventlog, processmap = process_map(eventlog, render = F,
  ...), renderer = renderer_graphviz(), mode = c("absolute",
  "relative", "off"), duration = 60, jitter = 0, timeline = TRUE,
  legend = NULL, initial_state = c("playing", "paused"),
  initial_time = 0, repeat_count = 1, repeat_delay = 0.5,
  epsilon_time = duration/1000, mapping = token_aes(),
  token_callback_onclick = c("function(svg_root, svg_element, case_id) {",
  "}"), token_callback_select = token_select_decoration(),
  activity_callback_onclick = c("function(svg_root, svg_element, activity_id) {",
  "}"), activity_callback_select = activity_select_decoration(),
  elementId = NULL, preRenderHook = NULL, width = NULL,
  height = NULL, ...)
}
\arguments{
\item{eventlog}{The event log object that should be animated}

\item{processmap}{The process map created with processmapR that the event log should be animated on,
if not provided a standard process map will be generated by using processmapR::process_map.}

\item{renderer}{Whether to use Graphviz (\code{\link{renderer_graphviz}}) to layout and render the process map,
or to render the process map using Leaflet ((\code{\link{renderer_leaflet}})) on a geographical map.}

\item{mode}{Whether to animate the cases according to their actual time of occurence ("absolute") or to start all cases at once ("relative").}

\item{duration}{The overall duration of the animation, all times are scaled according to this overall duration.}

\item{jitter}{The magnitude of a random coordinate translation, known as jitter in scatterplots, which is added to each token.
Adding jitter can help to disambiguate tokens traveling on top of each other.}

\item{timeline}{Whether to render a timeline slider in supported browsers (Recent versions of Chrome and Firefox only).}

\item{legend}{Whether to show a legend for the `size` or the `color` scale.}

\item{initial_state}{Whether the initial playback state is `playing` or `paused`.}

\item{initial_time}{Sets the initial time of the animation. The default is to start at the beginning (0).}

\item{repeat_count}{The number of times the process animation is repeated.}

\item{repeat_delay}{The seconds to wait before one repetition of the animation.}

\item{epsilon_time}{A (small) time to be added to every animation to ensure that tokens are visible.}

\item{mapping}{A list of aesthetic mappings from event log attributes to certain visual parameters of the tokens.
Use \code{\link{token_aes}} to create a suitable mapping list.}

\item{token_callback_onclick}{A JavaScript function that is called when a token is clicked.
The function is parsed by \code{\link{JS}} and received three parameters: 'svg_root', 'svg_element', and 'case_id'.}

\item{token_callback_select}{A JavaScript callback function called when token selection changes.}

\item{activity_callback_onclick}{A JavaScript function that is called when an activity is clicked.
The function is parsed by \code{\link{JS}} and received three parameters: 'svg_root', 'svg_element', and 'activity_id'.}

\item{activity_callback_select}{A JavaScript callback function called when activity selection changes.}

\item{elementId}{passed through to \code{\link{createWidget}}. A custom elementId is useful to capture the selection events
via input$elementId_tokens and input$elementId_activities when used in Shiny.}

\item{preRenderHook}{passed through to \code{\link{createWidget}}.}

\item{width, height}{Fixed size for widget (in css units).
The default is NULL, which results in intelligent automatic sizing based on the widget's container.}

\item{...}{Options passed on to \code{\link{process_map}}.}
}
\description{
A function for creating a SVG animation of an event log on a process map created by
 \code{\link{process_map}} from the processmapR package.
}
\examples{
data(example_log)

# Animate the process with default options (absolute time and 60s duration)
animate_process(example_log)
\donttest{
# Animate the process with default options (relative time, with jitter, infinite repeat)
animate_process(example_log, mode = "relative", jitter = 10, repeat_count = Inf)
}

}
\seealso{
\code{\link{process_map}}, \code{\link{token_aes}}
}
