% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_map.R
\name{process_map}
\alias{process_map}
\title{Process Map}
\usage{
process_map(eventlog, type = frequency("absolute"), render = T)
}
\arguments{
\item{eventlog}{The event log object for which to create a process map}

\item{type}{A process map type, which can be created with the functions frequency and performance. The first type focusses on the frequency aspect of a process, while the second one focussed on processing time.}

\item{render}{Whether the map should be rendered immediately (default), or rather an object of type dgr_graph should be returned.}
}
\description{
A function for creating a process map of an event log.
}
\examples{
\dontrun{
library(eventdataR)
data(patients)
process_map(patients)
}
}
