% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splines.R
\name{make_hat_mats}
\alias{make_hat_mats}
\title{Create a List of Hat Matrices}
\usage{
make_hat_mats(
  x,
  n = length(x),
  mu = 0.5,
  sigma = 1,
  nonc = 0,
  tailw = 1,
  deg = 1,
  ndiff = 1.5,
  lambda = -Inf,
  periodic = FALSE,
  idx = NULL,
  params = NULL
)
}
\arguments{
\item{x}{The predictor variable}

\item{n}{Number of knots}

\item{mu}{Beta distribution location parameter}

\item{sigma}{Beta distribution scale parameter}

\item{nonc}{Beta distribution noncentrality parameter}

\item{tailw}{Tailweight}

\item{deg}{Degree of splines}

\item{ndiff}{Sets the degree of the differencing matrix for creating
the penalty}

\item{lambda}{Penalty parameter (higher values lead to higher penalty)}

\item{periodic}{Create periodic penalty}

\item{idx}{\code{make_hat_mats()} will create a grid containing all
combinations of the parameters. If idx is set, this grid will
be subsetted to the rows specified by idx.}

\item{params}{Instead of the arguments above, a grid (data.frame
or named matrix) of parameters can be passed directly.}
}
\description{
This function creates a list of hat matrices and the corresponding
parameters. It is used in \code{online()} to create the hat matrices
for penalized smoothing.
}
