% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_tkprogressbar.R
\name{handler_tkprogressbar}
\alias{handler_tkprogressbar}
\title{Progression Handler: Progress Reported as a Tcl/Tk Progress Bars in the GUI}
\usage{
handler_tkprogressbar(
  intrusiveness = getOption("progressr.intrusiveness.gui", 1),
  target = "terminal",
  inputs = list(title = NULL, label = "message"),
  ...
)
}
\arguments{
\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{inputs}{(named list) Specifies from what sources the MS Windows
progress elements 'title' and 'label' should be updated. Valid sources are
\code{"message"}, \code{"sticky_message"} and \code{"non_sticky_message"}, where
\code{"message"} is short for \code{c("non_sticky_message", "sticky_message")}. For
example, \code{inputs = list(title = "sticky_message", label = "message")}
will update the 'title' component from sticky messages only,
whereas the 'label' component is updated using any message.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{\link[tcltk:tkProgressBar]{tcltk::tkProgressBar()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{tcltk} package and that the
current R session supports Tcl/Tk (\code{capabilities("tcltk")}).
}

\examples{
if (capabilities("tcltk") && requireNamespace("tcltk", quietly = TRUE)) {

  handlers("tkprogressbar")
  with_progress({ y <- slow_sum(1:10) })
  print(y)
  
}
}
