% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{affiliations}
\alias{affiliations}
\alias{authors}
\alias{display_metadata}
\alias{projects}
\title{View the \code{projects()}, \code{authors()}, and \code{affiliations()}
tables}
\usage{
affiliations(affiliation, authors = FALSE)

authors(author, affiliations = FALSE, projects = FALSE)

projects(project, authors = FALSE, archived = FALSE)
}
\arguments{
\item{projects, authors, affiliations}{Logical values indicating whether or not
to perform a left join with another metadata tibble. All \code{FALSE} by
default.}

\item{project, author, affiliation}{An optional (unique) vector of \code{id}s
and/or names. Only rows matching one or more entries will be returned.}

\item{archived}{Logical, indicating whether or not to include projects that
have been archived using \code{\link{archive_project}()}. False by default.}
}
\description{
Returns a tibble of the projects/authors/affiliations, filtered and joined
according to the entirely optional arguments.
}
\details{
If one or more of the \code{projects}, \code{authors}, or \code{affiliations}
arguments to set to \code{TRUE}, a \code{\link[dplyr]{left_join}} is
performed, with the "left" table being the one sharing the name of the
function being used. As such, rows that don't have matches in any other
tables will still show up in the output, and rows that have multiple matches
in other tables will yield multiple rows in the output. The "right" table's
\code{id} column will be renamed.

Since all these functions return \code{\link[tibble]{tibble}}s, the user can
further manipulate them using \code{\link[dplyr]{dplyr}} functions like
\code{\link[dplyr]{select}} and \code{\link[dplyr]{filter}}. See the last
example.
}
\examples{
\donttest{
# Included in \donttest{} to save time on example checking.

# SETUP
old_path <- Sys.getenv("PROJECTS_FOLDER_PATH")
setup_projects(path = tempdir(), .Renviron_path = fs::path_temp(".Renviron"))
new_affiliation(department_name = "Math Dept.",
                institution_name = "Springfield College",
                address = "123 College St, Springfield, AB")
new_affiliation(department_name = "Art Department",
                institution_name = "Springfield College",
                address = "321 University Boulevard, Springfield, AB",
                id = 42)
new_affiliation(department_name = "Central Intelligence Agency",
                institution_name = "United States Government",
                address = "888 Classified Dr, Washington DC")
new_affiliation(department_name = "Pyrotechnics",
                institution_name = "ACME")
new_author(given_names = "Spiro", last_name = "Agnew", degree = "LLB",
           affiliations = "Art D", id = 13)
new_author(given_names = "Plato", id = 303)
new_author(given_names = "Condoleezza", last_name = "Rice",
           affiliations = c(1, 42, "Agency", "ACME"))
new_project(title = "Test project 1", current_owner = "Plato")
new_project(title = "Test project 2", current_owner = "eezza")
new_project(title = "Test project 3", current_owner = "Plato")
new_project(title = "Fun project 4",  current_owner = "Rice")
new_project(title = "Fun project 5",  current_owner = "Rice")
#############################################################################

# View entire affiliations table
affiliations()

# View affiliations table joined to authors table
# Notice that multiple rows are created for each affiliation-author combination
affiliations(authors = TRUE)

# Using dplyr functions to query the tables:

# View authors table joined to affiliations table, and filter out duplicate
# author ids, leaving one row for each author, each including the author's
# primary (i.e., first) affiliation
authors(affiliations = TRUE) \%>\%
  dplyr::distinct(id, .keep_all = TRUE) \%>\%
  dplyr::select(id, given_names, last_name, email, phone, address)

# View all projects with "Test" in their title
projects(project = "Test")

# View projects table, including only projects with Plato as current owner
projects() \%>\% dplyr::filter(current_owner == 303)

# Wrapped in if(interactive()) because it requires interactive console input
# and fails automated testing.
if(interactive()) {
  # Archive Fun project 5
  archive_project("Fun project 5")

  # Default behavior is to not include archived projects in projects() table
  projects("Fun")
  projects("Fun", archived = TRUE)
}

#############################################################################
# CLEANUP
Sys.setenv(PROJECTS_FOLDER_PATH = old_path)
fs::file_delete(c(fs::path_temp("projects"), fs::path_temp(".Renviron")))
}
}
