% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/email_authors.R
\name{email_authors}
\alias{email_authors}
\title{Write an email to project authors}
\usage{
email_authors(
  project = NULL,
  browser = getOption("browser"),
  encodeIfNeeded = FALSE
)
}
\arguments{
\item{project}{Project \code{id} or unambiguous substring of the project name
from the \code{\link{projects}()} table. Defaults to \code{NULL} (see
\strong{Details}).}

\item{browser, encodeIfNeeded}{See \code{utils::\link[utils]{browseURL}()}.}
}
\description{
Invokes \code{utils::\link[utils]{browseURL}("mailto://[author emails]")} for
a specified project, or for the currently open project if \code{project} is
left as \code{NULL}.
}
\details{
The success of this function depends on the platform and the specified
\code{browser}. See the \strong{Details} and \strong{URL schemes} sections of
\code{utils::\link[utils]{browseURL}()}.

If \code{project = NULL}, the function selects the project in the
\code{\link{projects}()} table whose \code{path} is equal to
\code{rstudioapi::\link[rstudioapi]{getActiveProject}()}.
}
\examples{
# Wrapped in if (interactive()) because this function is interactive by nature.
if (interactive()) {

  # If you have a projects() project open, just run it:
  email_authors()

  # Otherwise, specify a project:

  ###########################################################################
  # Setup
  old_home <- Sys.getenv("HOME")
  old_ppath <- Sys.getenv("PROJECTS_FOLDER_PATH")
  temp_dir <- tempfile("dir")
  dir.create(temp_dir)
  Sys.unsetenv("PROJECTS_FOLDER_PATH")
  Sys.setenv(HOME = temp_dir)
  setup_projects(path = temp_dir)
  new_author("Rhonda", "Rondale", email = "ronda.rondale@co.uk")
  new_author("Betty", "Betts", email = "betty@co.uk")
  new_project("Inventing the Ring of Power", authors = c("Betty", "Ron"))
  ###########################################################################

  email_authors("Ring of Power")

  ###########################################################################
  # Cleanup (or just restart R)
  Sys.setenv(HOME = old_home, PROJECTS_FOLDER_PATH = old_ppath)
}
}
\seealso{
\code{utils::\link[utils]{browseURL}()};
  \code{rstudioapi::\link[rstudioapi]{getActiveProject}()} for information on
  \code{browser} and \code{encodeIfNeeded} arguments.
}
