% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_plan}
\alias{report_plan}
\title{Print plan in RMarkdown friendly way}
\usage{
report_plan(plan, show_ratio = TRUE)
}
\arguments{
\item{plan}{List of project plan, as returned by \code{read_plan()}}

\item{show_ratio}{Boolean. Whether or not to report (# Closed Items / # Total Items) for each group as a ratio}
}
\value{
Returns character string of HTML with class attribute to be correctly
    shown "as-is" in RMarkdown
}
\description{
Interprets list representation of plan, using HTML to format results in a highly readable and
attractive way. Resulting object returned is a character vector of HTML code with the added
class of \code{'knit_asis'} so that when included in an RMarkdown document knitting to HTML,
the results will be correctly rendered as HTML.
}
\details{
The resulting HTML unordered list (<ul>) is tagged with class 'report_plan' for custom CSS styling.
}
\examples{
\dontrun{
# the following could be run in RMarkdown
plan_path <- system.file("extdata", "plan-ex.yml", package = "projmgr", mustWork = TRUE)
my_plan <- read_plan(plan_path)
report_plan(my_plan)
}
}
\seealso{
Other plans and todos: \code{\link{post_plan}},
  \code{\link{post_todo}}, \code{\link{read_plan}},
  \code{\link{read_todo}}, \code{\link{report_todo}},
  \code{\link{template_yaml}}
}
\concept{plans and todos}
