% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_discussion}
\alias{report_discussion}
\title{Print issue comments in RMarkdown friendly way}
\usage{
report_discussion(comments, issue = NA, link_url = TRUE)
}
\arguments{
\item{comments}{Dataframe or tibble of comments for a single issue, as returned by \code{get_issue_comments()}}

\item{issue}{Optional dataframe or tibble of issues, as returned by \code{get_issues()}. If provided,
output includes issue-level data such as the title, initial description, creation date, etc.}

\item{link_url}{Boolean. Whether or not to provide link to each item, as provided by \code{url} column in dataset}
}
\value{
Returns character string of HTML with class attribute to be correctly
shown "as-is" in RMarkdown
}
\description{
Interprets dataframe or tibble of issues by breaking apart milestones and listing each
issue title as open or closed, and uses HTML to format results in a highly readable and
attractive way. Resulting object returned is a character vector of HTML code with the added
class of \code{'knit_asis'} so that when included in an RMarkdown document knitting to HTML,
the results will be correctly rendered as HTML.
}
\details{
HTML output is wrapped in a \verb{<div>} of class 'report_disccusion' for custom CSS styling.
}
\examples{
\dontrun{
# the following could be run in RMarkdown
repo <- create_repo_ref("emilyriederer", "projmgr")
issue <- get_issues(repo, number = 15)
issue_df <- parse_issues(issue)
comments <- get_issue_comments(repo, number = 15)
comments_df <- parse_issue_comments(comments)
report_discussion(issue_df, comments_df)
}
}
\seealso{
Other issues: 
\code{\link{get_issue_comments}()},
\code{\link{get_issue_events}()},
\code{\link{get_issues}()},
\code{\link{parse_issue_comments}()},
\code{\link{parse_issue_events}()},
\code{\link{parse_issues}()},
\code{\link{post_issue_update}()},
\code{\link{post_issue}()},
\code{\link{report_progress}()},
\code{\link{viz_waterfall}()}

Other comments: 
\code{\link{get_issue_comments}()},
\code{\link{parse_issue_comments}()}
}
\concept{comments}
\concept{issues}
