% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varsel.R
\name{varsel}
\alias{varsel}
\title{Variable selection for generalized linear models}
\usage{
varsel(fit, d_test = NULL, method = NULL, ns = NULL, nc = NULL,
  nspred = NULL, ncpred = NULL, nv_max = NULL, intercept = NULL,
  penalty = NULL, verbose = F, lambda_min_ratio = 1e-05, nlambda = 500,
  regul = 1e-06, ...)
}
\arguments{
\item{fit}{Either a \link[=stanreg-objects]{stanreg}-object or an object returned
by \link[=init_refmodel]{init_refmodel}.}

\item{d_test}{A test dataset, which is used to evaluate model performance.
If not provided, training data is used. Currently this argument is for internal use only.}

\item{method}{The method used in the variable selection. Possible options are
\code{'L1'} for L1-search and \code{'forward'} for forward selection.
Default is 'forward' if the number of variables in the full data is at most 20, and
\code{'L1'} otherwise.}

\item{ns}{Number of posterior draws used in the variable selection.
Cannot be larger than the number of draws in the full model.
Ignored if nc is set.}

\item{nc}{Number of clusters to use in the clustered projection.
Overrides the \code{ns} argument. Defaults to 1.}

\item{nspred}{Number of samples used for prediction (after selection). Ignored if ncpred is given.}

\item{ncpred}{Number of clusters used for prediction (after selection). Default is 5.}

\item{nv_max}{Maximum number of varibles until which the selection is continued.
Defaults to min(20, D, floor(0.4*n)) where n is the number of observations and
D the number of variables.}

\item{intercept}{Whether to use intercept in the submodels. Defaults to TRUE.}

\item{penalty}{Vector determining the relative penalties or costs for the variables.
Zero means that those variables have no cost and will therefore be selected first,
whereas Inf means that those variables will never be selected. Currently works only 
if method == 'L1'. By default 1 for each variable.}

\item{verbose}{If TRUE, may print out some information during the selection.
Defaults to FALSE.}

\item{lambda_min_ratio}{Ratio between the smallest and largest lambda in the L1-penalized search.
This parameter essentially determines how long the search is carried out, i.e., how large submodels
are explored. No need to change the default value unless the program gives a warning about this.}

\item{nlambda}{Number of values in the lambda grid for L1-penalized search. No need to change unless
the program gives a warning about this.}

\item{regul}{Amount of regularization in the projection. Usually there is no need for 
regularization, but sometimes for some models the projection can be ill-behaved and we
need to add some regularization to avoid numerical problems. Default is 1e-9.}

\item{...}{Currently ignored.}
}
\value{
The original fit-object object augmented with a field 'varsel',
which is a list containing the following elements:
\describe{
 \item{\code{vind}}{The order in which the variables were added to the submodel.}
 \item{\code{kl}}{KL-divergence for each submodel size.}
 \item{\code{summaries}}{Summary statistics computed during the selection.}
 \item{\code{d_test}}{The data used to evaluate the summaries.}
 \item{\code{family_kl}}{A modified \link{family}-object.}
}
}
\description{
Perform the projection predictive variable selection for a generalized
linear model fitted with rstanarm.
}
\examples{
\donttest{
### Usage with stanreg objects
fit <- stan_glm(y~x, binomial())
fit_v <- varsel(fit)
plot_varsel(fit_v)
}

}
