% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLASS_api_access.R, R/METHODS_api_access.R,
%   R/zzz.R
\docType{class}
\name{api_access}
\alias{api_access}
\alias{api_access-class}
\alias{API_ACCESS}
\alias{api_accessor}
\alias{accessors}
\alias{accessors<-}
\alias{api_token}
\alias{api_token<-}
\alias{entrypoint}
\alias{entrypoint<-}
\alias{access}
\alias{check_authorization}
\alias{prescreeners-method}
\title{Prolific API access}
\description{
This class provides functionalities for accessing the \href{https://docs.prolific.co/docs/api-docs/public/}{Prolific API}.
The core method for this purpose is \code{\link[=api_access]{access}}, which can be used
to create, review, change, manage and delete studies on the Prolific platform.\cr
\emph{The fields and methods are available as in RefClass or S4 objects (see examples).}
}
\section{Fields}{

\describe{
\item{\code{accessors}}{(\code{\link[=character]{character}}):\cr
The commands for accessing the API.
The command for each type of access method can be altered using this field.
The default is
\preformatted{
     accessors = c(
        get    = "curl",
        post   = "curl -X POST",
        put    = "curl -X PUT",
        patch  = "curl -X PATCH",
        delete = "curl -X DELETE"
     )
}
\strong{Note:} \emph{A value for each of the names \code{(get, post, put, patch and delete)} is required, as these represent the methods that can be used when accessing the API.}}

\item{\code{api_token}}{(\code{\link[=character]{character}}):\cr
The \href{https://docs.prolific.co/docs/api-docs/public/#section/Authentication}{Prolific API token}.}

\item{\code{entrypoint}}{(\code{\link[=character]{character}}):\cr
The \href{https://docs.prolific.co/docs/api-docs/public/#section/Get-started/Conventions}{API's entrypoint URL}.}
}}


\section{Methods}{

\subsection{\code{access}}{

Main method for accessing the \href{https://docs.prolific.co/docs/api-docs/public/}{Prolific API}
\subsection{\strong{Parameters}}{

\describe{
\item{\code{endpoint}}{(\code{\link[=character]{character}}):}\cr
The endpoint to access. If this is a vector, its elements are collapsed by \code{'/'}.
\item{\code{method}}{(\code{\link[=character]{character}}):}\cr
The method to use. One of \code{get, post, place, patch and delete}.
The commands associated with each method are defined in the \code{\link[=api_access]{accessors}} field of the \code{\link[=api_access]{api_access}} object.
\item{\code{data}}{(\code{\link[jsonlite:toJSON]{json string}}, \code{\link[jsonlite:toJSON]{json file}}, \code{\link[=list]{list}}, \code{\link[=prolific_study]{prolific_study object}} or \code{\link[=NULL]{NULL}})}\cr
The data to be transfered in the body of the \href{https://docs.prolific.co/docs/api-docs/public/}{API} call.
R-objects are converted to a \code{\link[jsonlite:toJSON]{json string}} using \code{\link[jsonlite:toJSON]{jsonlite:toJSON}} .
\code{\link[=NULL]{NULL}} means that no data is transfered.
\item{\code{as_list}}{(\code{\link[=logical]{logical}}):}\cr
Whether the return of the \href{https://docs.prolific.co/docs/api-docs/public/}{API} call should be converted to a list or (if applicable) \link[=prolific_study]{prolific_study} object,
rather than returned as the raw \code{\link[jsonlite:toJSON]{json string}}.
}
}

\subsection{\strong{Return Value}}{

A \code{\link[=list]{list}} or \code{\link[jsonlite:toJSON]{json string}}, depending on argument \code{as_list}.
}

\subsection{\strong{Usage}}{

\preformatted{
     api_access$access(
          endpoint,
          method,
          data,
          as_list
     )
}
}

}

\subsection{\code{check_authorization}}{

Check whether the \href{https://docs.prolific.co/docs/api-docs/public/#section/Authentication}{API authorization} works
\subsection{\strong{Return Value}}{

A \code{\link[=logical]{logical}} value that indicates whether the \href{https://docs.prolific.co/docs/api-docs/public/#section/Authentication}{API authorization} works.
}

\subsection{\strong{Usage}}{

\preformatted{
     api_access$check_authorization()
}
}

}
}

\examples{
library(prolific.api)

# Create API access
prolific_api_access <- api_access(api_token = "<api_token>")

# View fields
## RefClass Methods
prolific_api_access$accessors
prolific_api_access$api_token
prolific_api_access$entrypoint

## S4 Methods
accessors(prolific_api_access)
api_token(prolific_api_access)
entrypoint(prolific_api_access)

# Change fields
# (this is usually only required for the api_token)
# replace <new_token> in the by the actual API token
# before running these lines
\dontrun{
## RefClass Method
prolific_api_access$api_token <- "<new_token>"
## S4 Method
api_token(prolific_api_access) <- "<new_token>"
}


# Note: For the following code to work,
# you have to replace <new_token> in the lines above by the actual API token
\dontrun{
# Check wheter Authorization is working
## RefClass Method
prolific_api_access$check_authorization()
## S4 Method
check_authorization(prolific_api_access)

# Obtain list of existing studies
## RefClass Method
list_of_studies <-
    prolific_api_access$access(
        endpoint = "studies",
        method = "get",
        as_list = TRUE
    )
## S4 Method
list_of_studies2 <-
    access(
        prolific_api_access,
        endpoint = "studies",
        method = "get",
        as_list = TRUE
    )
}

}
