% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/224.CoverageProb_GENERAL_GIVEN_p.R
\name{covpGEN}
\alias{covpGEN}
\title{General Coverage Probability given hypothetical "p" Coverage probability for CI
obtained from any method and discrete hypothetical p}
\usage{
covpGEN(n, LL, UL, alp, hp, t1, t2)
}
\arguments{
\item{n}{- Number of trials}

\item{LL}{- Lower limit}

\item{UL}{- Upper limit}

\item{alp}{- Alpha value (significance level required)}

\item{hp}{- Hypothetical "p"}

\item{t1}{- Lower tolerance limit to check the spread of coverage Probability}

\item{t2}{- Upper tolerance limit to check the spread of coverage Probability}
}
\value{
A dataframe with
 \item{mcp}{  Mean Coverage Probability}
 \item{micp }{   Minimum coverage probability}
 \item{RMSE_N }{   Root Mean Square Error from nominal size}
 \item{RMSE_M }{   Root Mean Square Error for Mean Coverage Probability}
 \item{RMSE_MI }{  Root Mean Square Error for minimum coverage probability}
 \item{tol }{   Required tolerance for coverage probability}
}
\description{
General Coverage Probability given hypothetical "p" Coverage probability for CI
obtained from any method and discrete hypothetical p
}
\details{
Evaluation of intervals obtained from any method using
coverage probability, root mean square statistic, and the proportion of proportion
lies within the desired level of coverage for the \eqn{n + 1} intervals and pre-defined
space for the parameter \code{p}
}
\examples{
\dontrun{
LL=c(0,0.01,0.0734,0.18237,0.3344,0.5492)		#Lower and Upper Limits
UL=c(0.4507,0.6655,0.8176,0.9265,0.9899,1)
hp=seq(0,1,by=0.0001)
n= 5; alp=0.05; t1=0.93; t2=0.97
covpGEN(n,LL,UL,alp,hp,t1,t2)
}
}
\seealso{
Other General methods for coverage probability: \code{\link{PlotcovpGEN}}
}

