% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-proprViz.R
\name{slate}
\alias{slate}
\title{Build \code{propr} Results Table}
\usage{
slate(rho, k, prompt = TRUE, plotly = FALSE)
}
\arguments{
\item{rho}{A \code{propr} or \code{propd} object.}

\item{k}{An integer. For \code{propr} methods, the number
of co-clusters (where all pairs receive a specified color
if and only if both members belong to same the cluster).
For \code{propd} methods, the maximum number of PALs to index
when calculating \code{\link{pals}} in the network.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}

\item{plotly}{A logical scalar. Set to \code{TRUE} to produce
a dynamic plot using the \code{plotly} package.}
}
\description{
Builds a table of VLR, VLS, and proportionality
 for each feature pair in a \code{propr} object. If the
 argument \code{k} is provided, the table will also
 include co-cluster membership.
 Returns a \code{data.frame} of all pairwise relationships.
 If the argument \code{k} is provided, returns a list of
 the \code{data.frame} of pairwise relationships and the
 cluster membership.
}
