% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize_pb.R
\name{serialize_pb}
\alias{protolite}
\alias{serialize_pb}
\alias{unserialize_pb}
\title{Serialize to Protocol Buffers}
\usage{
serialize_pb(object, connection = NULL)

unserialize_pb(msg)
}
\arguments{
\item{object}{an R object to serialize}

\item{connection}{a connection, file, or \code{NULL} for a raw vector}

\item{msg}{raw vector with the serialized \code{rexp.proto} message}
}
\description{
Serializes R objects to a general purpose protobuf message. It uses the same
\code{rexp.proto} descriptor and mapping between R objects and protobuf messages
as RHIPE and the \code{RProtoBuf} package.
}
\details{
The \code{serialize_pb} and \code{unserialize_pb} reimplement the identically
named functions from the \code{RProtoBuf} package in pure \code{C++}. This makes
the function faster and simpler, but the output should be identical.
}
\examples{
# Serialize and unserialize an object
buf <- serialize_pb(iris)
out <- unserialize_pb(buf)
stopifnot(identical(iris, out))

\dontrun{ #Fully compatible with RProtoBuf
buf <- RProtoBuf::serialize_pb(iris, NULL)
out <- protolite::unserialize_pb(buf)
stopifnot(identical(iris, out))

# Other way around
buf <- protolite::serialize_pb(mtcars, NULL)
out <- RProtoBuf::unserialize_pb(buf)
stopifnot(identical(mtcars, out))
}
}

