% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc-03-TC.R
\name{extractTC}
\alias{extractTC}
\title{Tripeptide Composition Descriptor}
\usage{
extractTC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 8,000 named vector
}
\description{
This function calculates the Tripeptide Composition descriptor (dim: 8,000).
}
\examples{
x = readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]
extractTC(x)
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on
Amino Acid Composition and Dipeptide Composition.
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See \code{\link{extractAAC}} and \code{\link{extractDC}}
for Amino Acid Composition and Dipeptide Composition descriptors.
}
\keyword{Composition}
\keyword{Tripeptide}
\keyword{extract}

