% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_sample_correlation.R
\name{qc_sample_correlation}
\alias{qc_sample_correlation}
\title{Correlation based hirachical clustering of samples}
\usage{
qc_sample_correlation(
  data,
  sample,
  grouping,
  intensity_log2,
  condition,
  digestion = NULL,
  run_order = NULL,
  method = "spearman",
  interactive = FALSE
)
}
\arguments{
\item{data}{a dataframe contains at least the input variables.}

\item{sample}{the name of the column containing the sample names.}

\item{grouping}{the name of the column containing precursor or peptide identifiers.}

\item{intensity_log2}{the name of the column containing log2 intensity values.}

\item{condition}{the name of the column containing the conditions.}

\item{digestion}{optional, the name of the column containing information about the digestion method used. Eg. "LiP" or "tryptic control".}

\item{run_order}{optional, the name of the column containing the order in which samples were measured. Useful to investigate batch effects due to run order.}

\item{method}{the method to be used for correlation. \code{"spearman"} is the default but can be changed to \code{"pearson"} or \code{"kendall"}.}

\item{interactive}{logical, default is \code{FALSE}. Determines if an interactive or static heatmap should be created using \code{heatmaply} or \code{pheatmap}, respectively.}
}
\value{
A correlation heatmap that compares each sample. The dendrogram is sorted by optimal leaf ordering.
}
\description{
A correlation heatmap is created that uses hirachical clustering to determine sample similarity.
}
\examples{
\dontrun{
qc_sample_correlation(
  data,
  sample = r_file_name,
  grouping = eg_precursor_id,
  intensity_log2 = intensity_log2,
  condition = r_condition
)
}
}
