% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/try_query.R
\name{try_query}
\alias{try_query}
\title{Query from URL}
\usage{
try_query(
  url,
  max_tries = 5,
  silent = TRUE,
  type = "text/tab-separated-values",
  timeout = 60,
  accept = NULL,
  ...
)
}
\arguments{
\item{url}{a character value of an URL to the website that contains the table that should be
downloaded.}

\item{max_tries}{a numeric value that specifies the number of times the function tries to download
the data in case an error occurs.}

\item{silent}{a logical value that specifies if individual messages are printed after each try
that failed.}

\item{type}{a character value that specifies the type of data at the target URL. Options are
all options that can be supplied to httr::content, these include e.g.
"text/tab-separated-values", "application/json" and "txt/csv". Default is "text/tab-separated-values".
Default is "tab-separated-values".}

\item{timeout}{a numeric value that specifies the maximum request time. Default is 60 seconds.}

\item{accept}{a character value that specifies the type of data that should be sent by the API if
it uses content negotiation. The default is NULL and it should only be set for APIs that use
content negotiation.}

\item{...}{other parameters supplied to the parsing function used by httr::content.}
}
\value{
A data frame that contains the table from the url.
}
\description{
Downloads data table from URL. If an error occurs during the query (for example due to no
connection) the function waits 3 seconds and tries again. If no result could be obtained
after the given number of tries a message indicating the problem is returned.
}
