/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.Cancellable;
import com.qarks.util.CancellableImpl;
import com.qarks.util.files.diff.DirContentStatus;
import com.qarks.util.files.diff.DirDiffResult;
import com.qarks.util.files.diff.core.FolderComparator;
import com.qarks.util.files.diff.ui.DiffProvider;
import com.qarks.util.files.diff.ui.FileDiffDialog;
import com.qarks.util.files.diff.ui.LineCellRenderer;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DirDiffPanel
extends JPanel {
    private JButton compareFolders;
    private JButton compareFiles;
    private DefaultMutableTreeNode leftRoot;
    private DefaultMutableTreeNode rightRoot;
    private JTree leftTree;
    private JTree rightTree;
    private JList modifiedFiles;
    private DefaultListModel listModel;
    private DefaultTreeModel leftTreeModel;
    private DefaultTreeModel rightTreeModel;
    private JScrollPane leftScroll;
    private JScrollPane rightScroll;
    private FolderComparatorMonitor comparator;
    private DiffProvider diffProvider;
    private String currentDir = "";
    private TitledBorder leftBorder;
    private TitledBorder rightBorder;
    private boolean selection = false;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jFrame.getContentPane().add(new DirDiffPanel(null));
        jFrame.setSize(800, 600);
        DialogUtilities.centerOnScreen(jFrame);
    }

    public DirDiffPanel(DiffProvider diffProvider) {
        this.diffProvider = diffProvider;
        FolderTreeRenderer folderTreeRenderer = new FolderTreeRenderer();
        this.listModel = new DefaultListModel();
        this.modifiedFiles = new JList(this.listModel);
        this.leftRoot = new DefaultMutableTreeNode();
        this.leftTreeModel = new DefaultTreeModel(this.leftRoot);
        this.leftTree = new JTree(this.leftTreeModel);
        this.leftTree.setRootVisible(false);
        this.leftTree.setShowsRootHandles(true);
        this.leftScroll = new JScrollPane(this.leftTree);
        this.leftTree.setCellRenderer(folderTreeRenderer);
        this.rightRoot = new DefaultMutableTreeNode();
        this.rightTreeModel = new DefaultTreeModel(this.rightRoot);
        this.rightTree = new JTree(this.rightTreeModel);
        this.rightTree.setRootVisible(false);
        this.rightTree.setShowsRootHandles(true);
        this.rightScroll = new JScrollPane(this.rightTree);
        this.rightTree.setCellRenderer(folderTreeRenderer);
        this.compareFolders = new JButton(ResourceManager.getString((Object)ResourceKeyDiff.COMPARE_FOLDERS));
        this.compareFiles = new JButton(ResourceManager.getString((Object)ResourceKeyDiff.COMPARE_FILES));
        this.compareFiles.setEnabled(false);
        this.leftBorder = new TitledBorder("-");
        this.rightBorder = new TitledBorder("-");
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 0, 0));
        jPanel.add(this.compareFolders);
        jPanel.add(this.compareFiles);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.setBorder(this.leftBorder);
        jPanel3.add((Component)this.leftScroll, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.setBorder(this.rightBorder);
        jPanel4.add((Component)this.rightScroll, "Center");
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel5.add((Component)jPanel3, 0);
        jPanel5.add((Component)jPanel4, 1);
        JPanel jPanel6 = new JPanel(new BorderLayout(5, 5));
        jPanel6.add((Component)new JScrollPane(this.modifiedFiles), "Center");
        jPanel6.setBorder(new TitledBorder(ResourceManager.getString((Object)ResourceKeyDiff.MODIFIED_FILES)));
        jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel2.add((Component)jPanel5, 0);
        jPanel2.add((Component)jPanel6, 1);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.compareFolders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirDiffPanel.this.compareFolders();
            }
        });
        this.compareFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirDiffPanel.this.compareFiles();
            }
        });
        this.leftTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!DirDiffPanel.this.selection) {
                    DirDiffPanel.this.selection = true;
                    DirDiffPanel.this.rightTree.getSelectionModel().setSelectionPath(null);
                    DirDiffPanel.this.modifiedFiles.getSelectionModel().clearSelection();
                    DirDiffPanel.this.checkSelection();
                    DirDiffPanel.this.selection = false;
                }
            }
        });
        this.modifiedFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!DirDiffPanel.this.selection) {
                    DirDiffPanel.this.selection = true;
                    DirDiffPanel.this.rightTree.getSelectionModel().setSelectionPath(null);
                    DirDiffPanel.this.leftTree.getSelectionModel().setSelectionPath(null);
                    DirDiffPanel.this.checkSelection();
                    DirDiffPanel.this.selection = false;
                }
            }
        });
        this.rightTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!DirDiffPanel.this.selection) {
                    DirDiffPanel.this.selection = true;
                    DirDiffPanel.this.leftTree.getSelectionModel().setSelectionPath(null);
                    DirDiffPanel.this.modifiedFiles.getSelectionModel().clearSelection();
                    DirDiffPanel.this.checkSelection();
                    DirDiffPanel.this.selection = false;
                }
            }
        });
    }

    public void compareFolders() {
        Window window = SwingUtilities.getWindowAncestor(this);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setCurrentDirectory(new File(this.currentDir));
        jFileChooser.setDialogTitle("Select first folder");
        if (jFileChooser.showOpenDialog(window) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.currentDir = file.getParent();
            jFileChooser.setDialogTitle("Select second folder");
            if (jFileChooser.showOpenDialog(window) == 0) {
                File file2 = jFileChooser.getSelectedFile();
                this.compareFolders(file, file2);
            }
        }
    }

    private void compareFiles() {
        TreePath treePath = this.leftTree.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode != null) {
                DirContentStatus dirContentStatus = (DirContentStatus)defaultMutableTreeNode.getUserObject();
                this.compareFiles(dirContentStatus);
            }
        } else {
            TreePath treePath2 = this.rightTree.getSelectionModel().getSelectionPath();
            if (treePath2 != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
                if (defaultMutableTreeNode != null) {
                    DirContentStatus dirContentStatus = (DirContentStatus)defaultMutableTreeNode.getUserObject();
                    this.compareFiles(dirContentStatus);
                }
            } else if (this.modifiedFiles.getSelectedValue() != null) {
                DirContentStatus dirContentStatus = (DirContentStatus)this.modifiedFiles.getSelectedValue();
                this.compareFiles(dirContentStatus);
            }
        }
    }

    private void compareFiles(DirContentStatus dirContentStatus) {
        if (this.diffProvider != null) {
            this.diffProvider.compareFiles(this, dirContentStatus.getFile(), dirContentStatus.getOtherFile());
        } else {
            Window window = SwingUtilities.getWindowAncestor(this);
            FileDiffDialog.showDiffDialog(window, dirContentStatus.getFile(), dirContentStatus.getOtherFile());
        }
    }

    private void checkSelection() {
        TreePath treePath = this.leftTree.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode != null) {
                DirContentStatus dirContentStatus = (DirContentStatus)defaultMutableTreeNode.getUserObject();
                this.compareFiles.setEnabled(dirContentStatus.getStatus() == DirContentStatus.Status.MODIFIED);
            } else {
                this.compareFiles.setEnabled(false);
            }
        } else {
            TreePath treePath2 = this.rightTree.getSelectionModel().getSelectionPath();
            if (treePath2 != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
                if (defaultMutableTreeNode != null) {
                    DirContentStatus dirContentStatus = (DirContentStatus)defaultMutableTreeNode.getUserObject();
                    this.compareFiles.setEnabled(dirContentStatus.getStatus() == DirContentStatus.Status.MODIFIED);
                } else {
                    this.compareFiles.setEnabled(false);
                }
            } else if (this.modifiedFiles.getSelectedValue() != null) {
                DirContentStatus dirContentStatus = (DirContentStatus)this.modifiedFiles.getSelectedValue();
                this.compareFiles.setEnabled(dirContentStatus != null);
            } else {
                this.compareFiles.setEnabled(false);
            }
        }
    }

    public void compareFolders(File file, File file2) {
        if (this.comparator != null) {
            this.comparator.cancel();
        }
        this.comparator = new FolderComparatorMonitor(file, file2);
        this.comparator.start();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.compareFolders.setEnabled(false);
    }

    private void onFinish(DirDiffResult dirDiffResult) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.compareFolders.setEnabled(true);
        if (dirDiffResult != null) {
            this.leftBorder.setTitle(dirDiffResult.getLeftContent().getFile().getName());
            this.rightBorder.setTitle(dirDiffResult.getRightContent().getFile().getName());
            this.listModel.clear();
            this.leftRoot.removeAllChildren();
            this.leftTreeModel.nodeStructureChanged(this.leftRoot);
            this.rightRoot.removeAllChildren();
            this.rightTreeModel.nodeStructureChanged(this.rightRoot);
            this.buildModifiedFiles(dirDiffResult.getLeftContent());
            this.addNode(this.leftRoot, this.leftTreeModel, dirDiffResult.getLeftContent());
            this.addNode(this.rightRoot, this.rightTreeModel, dirDiffResult.getRightContent());
            this.leftTree.expandPath(new TreePath(new Object[]{this.leftRoot, this.leftRoot.getChildAt(0)}));
            this.rightTree.expandPath(new TreePath(new Object[]{this.rightRoot, this.rightRoot.getChildAt(0)}));
            this.repaint();
        }
    }

    private void buildModifiedFiles(DirContentStatus dirContentStatus) {
        if (dirContentStatus.getStatus() == DirContentStatus.Status.MODIFIED && !dirContentStatus.getFile().isDirectory()) {
            this.listModel.addElement(dirContentStatus);
        }
        for (DirContentStatus dirContentStatus2 : dirContentStatus.getChildren()) {
            this.buildModifiedFiles(dirContentStatus2);
        }
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultTreeModel defaultTreeModel, DirContentStatus dirContentStatus) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(dirContentStatus);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.setParent(defaultMutableTreeNode);
        defaultTreeModel.nodesWereInserted(defaultMutableTreeNode, new int[]{defaultMutableTreeNode.getChildCount() - 1});
        dirContentStatus.sort();
        List<DirContentStatus> list = dirContentStatus.getChildren();
        for (DirContentStatus dirContentStatus2 : list) {
            this.addNode(defaultMutableTreeNode2, defaultTreeModel, dirContentStatus2);
        }
    }

    private class FolderTreeRenderer
    extends DefaultTreeCellRenderer {
        private Icon dirIcon = UIManager.getIcon("FileView.directoryIcon");
        private Icon fileIcon = UIManager.getIcon("FileView.fileIcon");

        public FolderTreeRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof DirContentStatus) {
                DirContentStatus dirContentStatus = (DirContentStatus)object2;
                this.setText(dirContentStatus.getFile().getName());
                if (dirContentStatus.getFile().isDirectory()) {
                    this.setIcon(this.dirIcon);
                } else {
                    this.setIcon(this.fileIcon);
                }
                if (dirContentStatus.getStatus() == DirContentStatus.Status.NEW) {
                    if (bl) {
                        this.setBackground(LineCellRenderer.INSERTED_COLOR.darker());
                    } else {
                        this.setBackground(LineCellRenderer.INSERTED_COLOR);
                    }
                } else if (dirContentStatus.getStatus() == DirContentStatus.Status.MODIFIED) {
                    if (bl) {
                        this.setBackground(LineCellRenderer.MODIFIED_COLOR.darker());
                    } else {
                        this.setBackground(LineCellRenderer.MODIFIED_COLOR);
                    }
                } else {
                    Color color = null;
                    color = bl ? Color.gray : Color.white;
                    this.setBackground(color);
                }
            }
            return this;
        }
    }

    private class FolderComparatorMonitor
    extends Thread {
        private DirDiffResult result = null;
        private Cancellable cancellable = new CancellableImpl();
        private File leftFolder;
        private File rightFolder;

        public FolderComparatorMonitor(File file, File file2) {
            this.leftFolder = file;
            this.rightFolder = file2;
        }

        public void cancel() {
            this.cancellable.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.result = FolderComparator.compareFolders(this.leftFolder, this.rightFolder, this.cancellable);
                if (this.cancellable.isCancelled()) return;
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                    if (this.cancellable.isCancelled()) return;
                }
                catch (Throwable throwable) {
                    if (this.cancellable.isCancelled()) throw throwable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DirDiffPanel.this.onFinish(FolderComparatorMonitor.this.result);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
    }
}

