/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.ui.LineCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.JPanel;

public class MergeOverview
extends JPanel {
    private int totalSize;
    private ArrayList<Interval> intervals = new ArrayList();

    public void clear() {
        this.intervals.clear();
        this.totalSize = 0;
    }

    public void addInterval(int n, int n2) {
        this.intervals.add(new Interval(n, n2));
        this.totalSize += n;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = dimension.width;
        float f = dimension.height;
        float f2 = this.totalSize;
        int n3 = (int)(f / f2);
        int n4 = Math.max(n3, 3);
        n4 = Math.min(n4, n);
        int n5 = 0;
        for (Interval interval : this.intervals) {
            for (int i = 0; i < interval.size; ++i) {
                int n6 = n4 == n ? n5 * n : (int)((float)dimension.height - (float)(this.totalSize - n5) * f / f2);
                boolean bl = false;
                Color color = Color.white;
                if (interval.status == 6) {
                    color = LineCellRenderer.CONFLICT_COLOR;
                    bl = true;
                } else if (interval.status == 4) {
                    color = LineCellRenderer.WARNING_COLOR;
                    bl = true;
                } else if (interval.status == 5) {
                    color = LineCellRenderer.WARNING_COLOR.brighter();
                    bl = true;
                }
                if (bl) {
                    graphics.setColor(color);
                    for (int j = 0; j < dimension.height && j <= n4; ++j) {
                        graphics.drawLine(0, n6 + j, n2, n6 + j);
                    }
                }
                ++n5;
            }
        }
    }

    private class Interval {
        public int size;
        public int status;

        public Interval(int n, int n2) {
            this.size = n;
            this.status = n2;
        }
    }
}

