% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{as.counts}
\alias{as.counts}
\title{create a \code{counts} object}
\usage{
as.counts(x, method = "chisq", colmap = "rainbow")
}
\arguments{
\item{x}{an object of class \code{matrix} or \code{data.frame}}

\item{method}{either \code{"chisq"} (for the chi-square distance)
or \code{"bray"} (for the Bray-Curtis distance)}

\item{colmap}{the colour map to be used in pie charts.}
}
\value{
an object of class \code{counts}
}
\description{
Convert an object of class \code{matrix} or \code{data.frame} to an
object of class \code{counts}
}
\examples{
X <- matrix(c(0,100,0,30,11,2,94,36,0),nrow=3,ncol=3)
rownames(X) <- 1:3
colnames(X) <- c('a','b','c')
comp <- as.counts(X)
d <- diss(comp)
}
