% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{simil}
\alias{simil}
\alias{dist}
\title{Compute similarity/distance between rows or columns of large matrices}
\usage{
simil(
  x,
  y = NULL,
  margin = 1,
  method = c("cosine", "correlation", "jaccard", "ejaccard", "dice", "edice", "hamann",
    "faith", "simple matching"),
  min_simil = NULL,
  rank = NULL,
  drop0 = FALSE,
  diag = FALSE,
  use_nan = FALSE,
  digits = 14
)

dist(
  x,
  y = NULL,
  margin = 1,
  method = c("euclidean", "chisquared", "kullback", "jeffreys", "jensen", "manhattan",
    "maximum", "canberra", "minkowski", "hamming"),
  p = 2,
  smooth = 0,
  drop0 = FALSE,
  diag = FALSE,
  use_nan = FALSE,
  digits = 14
)
}
\arguments{
\item{x}{\link{matrix} or \link{Matrix} object. Dense matrices are covered to
the \link{CsparseMatrix-class} internally.}

\item{y}{if a \link{matrix} or \link{Matrix} object is provided, proximity
between documents or features in \code{x} and \code{y} is computed.}

\item{margin}{integer indicating margin of similarity/distance computation. 1
indicates rows or 2 indicates columns.}

\item{method}{method to compute similarity or distance}

\item{min_simil}{the minimum similarity value to be recorded.}

\item{rank}{an integer value specifying top-n most similarity values to be
recorded.}

\item{drop0}{if \code{TRUE}, zero values are removed regardless of
\code{min_simil} or \code{rank}.}

\item{diag}{if \code{TRUE}, only compute diagonal elements of the
similarity/distance matrix; useful when comparing corresponding rows or
columns of `x` and `y`.}

\item{use_nan}{if \code{TRUE}, return `NaN` if the standard deviation of a
vector is zero when `method` is "correlation"; if all the values are zero
in a vector when `method` is "cosine", "chisquared", "kullback", "jeffreys"
or "jensen". Note that use of `NaN` makes the similarity/distance matrix
denser and therefore larger in RAM.}

\item{digits}{determines rounding of small values towards zero. Use primarily
to correct rounding errors in C++. See \link{zapsmall}.}

\item{p}{weight for Minkowski distance}

\item{smooth}{adds a  fixed value to all the cells to avoid division by zero.
Only used when `method` is "chisquared", "kullback" or "jeffreys".}
}
\description{
Fast similarity/distance computation function for large sparse matrices. You
can floor small similarity value to to save computation time and storage
space by an arbitrary threshold (\code{min_simil}) or rank (\code{rank}).
Please increase the number of threads for better performance using
\code{\link[RcppParallel]{setThreadOptions}}.
}
\details{
Available methods for similarity:
\itemize{
  \item `cosine`: cosine similarity
  \item `correlation`: Pearson's correlation
  \item `jaccard`: Jaccard coefficient
  \item `ejaccard`: the real value version of `jaccard`
  \item `dice`: Dice coefficient
  \item `edice`: the real value version of `dice`
  \item `hamann`: Hamann similarity
  \item `faith`: Faith similarity
  \item `simple matching`: the percentage of common elements
}
Available methods for distance:
\itemize{
  \item `euclidean`: Euclidean distance
  \item `chisquared`: chi-squared distance
  \item `kullback`: Kullback–Leibler divergence
  \item `jeffreys`: Jeffreys divergence
  \item `jensen`: Jensen–Shannon divergence
  \item `manhattan`: Manhattan distance
  \item `maximum`: the largest difference between values
  \item `canberra`: Canberra distance
  \item `minkowski`: Minkowski distance
  \item `hamming`: Hamming distance
}
}
\examples{
mt <- Matrix::rsparsematrix(100, 100, 0.01)
simil(mt, method = "cosine")[1:5, 1:5]
mt <- Matrix::rsparsematrix(100, 100, 0.01)
dist(mt, method = "euclidean")[1:5, 1:5]
}
\seealso{
zapsmall
}
