% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_covariates.R
\name{add_covariates}
\alias{add_covariates}
\title{Add Covariates for Model Adjustment}
\usage{
add_covariates(covariates, priors)
}
\arguments{
\item{covariates}{character. Names of columns in the data matrix containing
covariates to be adjusted for in the outcome model. Note: the
external and treatment flags should not go here.}

\item{priors}{Either a single object of class \code{Prior} specifying the prior
distribution to apply to all covariates or a named list of
distributions of class \code{Prior}, one for each covariate}
}
\value{
Object of class \code{\link[=Covariates-class]{Covariates}}.
}
\description{
Specify column names for adjustment variables in model matrix and prior
distributions for the model parameters for these covariates (i.e., betas)
}
\examples{
add_covariates(
  covariates = c("a", "b"),
  priors = list(
    "a" = prior_normal(0, 1),
    "b" = prior_normal(0, 2)
  )
)
}
