% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymbolic.R
\name{psymbolic}
\alias{psymbolic}
\title{Polygonal Symbolic Data}
\usage{
psymbolic(pdata, vertices)
}
\arguments{
\item{pdata}{an object of the class 'paggregated' that represents the representation 
of symbolic polygonal data.}

\item{vertices}{the number of vertices for the polygon.}
}
\value{
psdata is an object of class 'polygonal-variables', i.e. an environment, where for each object in the environment is a list with
the polygons(matrix with dimention l times 2, where l represents the number of vertices).
}
\description{
The function obtain a symbolic polygonal variables from data of
class 'paggregated', i.e aggregated data. For this, the researcher need to select
the number of vertices.
}
\details{
psymbolic converts data represented by center and radius representation in 
symbolic polygonal data. It is importat that the researcher considers a positive number 
for radius. Besides, the variable vertices should be greater than 2 for the number of vertices. 

When the object of class 'paggregated' is composed by a vector for center and one vector for
radius a simple symbolic variable is obtained.
}
\examples{
## Obtaining a simple symbolic polygonal variable
cat1 <- as.factor(sample(1:20, 1000, replace = TRUE))
cv1 <- runif(1000) #classical variable
cvc1 <- data.frame(category = cat1, variable = cv1) 
pol1 <- paggreg(cvc1)
out <- psymbolic(pol1, 6) #Hexagon
out$X1

## Obtaining three (or more) symbolic polygonal variables
cat2 <- as.factor(sample(1:20, 1000, replace = TRUE))
cv2 <- matrix(runif(3000), ncol = 3) #classical variable
cvc2 <- data.frame(category = cat2, cv2) 
pol2 <- paggreg(cvc2)
out2 <- psymbolic(pol2, 8) #Octagon
out2$X1
out2$X2
out2$X3 
}
