% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseval-constructors.R
\name{add_riskmodel}
\alias{add_riskmodel}
\title{Add risk model to a psdesign object}
\usage{
add_riskmodel(psdesign, riskmodel)
}
\arguments{
\item{psdesign}{A psdesign object}

\item{riskmodel}{A risk model object, from the list above}
}
\description{
Add risk model to a psdesign object
}
\details{
The risk model component specifies the likelihood for the data. This involves specifying the distribution of the outcome variable, whether it is binary or time-to-event, and specifying how the surrogate S(1) and the treatment Z interact and affect the outcome. We use the formula notation to be consistent with other regression type models in R. Below is a list of available risk models.

\itemize{
\item \link{risk_binary} This is a generic risk model for binary outcomes. The user can specify the formula, and link function using either \link{risk.logit} for the logistic link, or \link{risk.probit} for the probit link. Custom link functions may also be specified, which take a single numeric vector argument, and returns a vector of corresponding probabilities.
\item \link{risk_weibull} This is a parameterization of the Weibull model for time-to-event outcomes that is consistent with that of \link{rweibull}. The user specifies the formula for the linear predictor of the scale parameter.
\item \link{risk_exponential} This is a simple exponential model for a time-to-event outcome.
}
}
\examples{
test <- psdesign(generate_example_data(n = 100), Z = Z, Y = Y.obs, S = S.obs, BIP = BIP) +
     integrate_parametric(S.1 ~ BIP)
add_riskmodel(test, risk_binary())
test + risk_binary() # same as above
}

