% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_MI.R
\name{boot_MI}
\alias{boot_MI}
\title{Bootstrap validation in Multiply Imputed datasets}
\usage{
boot_MI(
  pobj,
  data_orig,
  nboot = 10,
  nimp_mice,
  p.crit,
  direction,
  miceImp,
  ...
)
}
\arguments{
\item{pobj}{An object of class \code{pmods} (pooled models), produced by a previous
call to \code{psfmi_lr}.}

\item{data_orig}{dataframe of original dataset that contains missing data.}

\item{nboot}{The number of bootstrap resamples, default is 10.}

\item{nimp_mice}{Numerical scalar. Number of multiple imputation runs.}

\item{p.crit}{A numerical scalar. P-value selection criterium used for backward
or forward selection during in the bootstrap samples. When set at 1, validation is done
without variable selection.}

\item{direction}{The direction of predictor selection, "BW" is for backward selection and
"FW" for forward selection.}

\item{miceImp}{Wrapper function around the \code{mice} function.}

\item{...}{Arguments as predictorMatrix, seed, maxit, etc that can be adjusted for
the \code{mice} function.}
}
\description{
\code{boot_MI} Bootstrapping followed by Multiple Imputation for internal validation.
 Called by function \code{psfmi_perform}.
}
\seealso{
\code{\link{psfmi_perform}}
}
\author{
Martijn Heymans, 2020
}
\keyword{internal}
