% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_coxr_bw.R
\name{psfmi_coxr_bw}
\alias{psfmi_coxr_bw}
\title{Backward selection of Cox regression models in multiply imputed data.}
\usage{
psfmi_coxr_bw(data, nimp, impvar, status, time, P, p.crit, method, keep.P)
}
\arguments{
\item{data}{Data frame with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar, and starting by 1.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{status}{The status variable, normally 0=censoring, 1=event.}

\item{time}{Follow up time.}

\item{P}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined. Give predictors unique names
and do not use predictor name combinations with numbers as, age2, BMI10, etc.}

\item{p.crit}{A numerical scalar. P-value selection criterium. A value of 1
provides the pooled model without selection.}

\item{method}{A character vector to indicate the pooling method for p-values to pool the
total model or used during predictor selection. This can be "RR", D1", "D2" or "MPR".
See details for more information. Default is "RR".}

\item{keep.P}{A single string or a vector of strings including the variables that are forced
in the model during predictor selection. All type of variables are allowed.}
}
\description{
\code{psfmi_coxr_bw} Backward selection of Cox regression
models in multiply imputed data using selection methods RR, D1, D2 and MPR.
Function is called by \code{psfmi_coxr}.
}
\author{
Martijn Heymans, 2020
}
\keyword{internal}
