% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nri_est.R
\name{nri_est}
\alias{nri_est}
\title{Calculation of Net Reclassification Index measures}
\usage{
nri_est(data, p0, p1, time, status, t_risk, cutoff)
}
\arguments{
\item{data}{Data frame with relevant predictors}

\item{p0}{risk outcome probabilities for reference model.}

\item{p1}{risk outcome probabilities for new model.}

\item{time}{Character vector. Name of time variable.}

\item{status}{Character vector. Name of status variable.}

\item{t_risk}{Follow-up value to calculate cases, controls. See details.}

\item{cutoff}{A numerical vector that defines the outcome probability cutoff values.}
}
\value{
An object from which the following objects can be extracted: 
 \itemize{
 \item  \code{prop_up_case} proportion of cases reclassified upwards. 
 \item  \code{prop_down_case} proportion of cases reclassified downwards.
 \item  \code{prop_up_ctr} proportion of controls reclassified upwards.
 \item  \code{prop_down_ctr} proportion of controls reclassified downwards.
 \item  \code{nri_plus} proportion reclassified for events.
 \item  \code{nri_min} proportion reclassified for nonevents. 
 \item  \code{nri} net reclassification improvement.
}
}
\description{
\code{nri_est} Calculation of proportion of Reclassified persons and NRI for Cox 
 Regression Models
}
\details{
Follow-up for which cases nd controls are determined. For censored cases before this follow-up 
 the expected risk of being a case is calculated by using the Kaplan-Meier value to calculate
 the expected number of cases. These expected numbers are used to calculate the NRI proportions 
 but are not shown by function \code{nricens}.
}
\examples{
  library(survival)
  lbpmicox1 <- subset(psfmi::lbpmicox, Impnr==1) # extract dataset
  
  fit_cox0 <- 
    coxph(Surv(Time, Status) ~ Duration + Pain, data=lbpmicox1, x=TRUE)
  fit_cox1 <- 
    coxph(Surv(Time, Status) ~ Duration + Pain + Function + Radiation, 
    data=lbpmicox1, x=TRUE)

  p0 <- risk_coxph(fit_cox0, t_risk=80)
  p1 <- risk_coxph(fit_cox1, t_risk=80)
  
  nri <- nri_est(data=lbpmicox1,
                      p0=p0,
                      p1=p1,
                      time = "Time",
                      status = "Status",
                      cutoff=0.45,
                      t_risk=80)

}
\references{
Cook NR, Ridker PM. Advances in measuring the effect of individual predictors of 
 cardiovascular risk: the role of reclassification measures. Ann Intern Med. 2009;150(11):795-802.

Steyerberg EW, Pencina MJ. Reclassification calculations for persons with incomplete 
 follow-up. Ann Intern Med. 2010;152(3):195-6; author reply 196-7.

Pencina MJ, D'Agostino RB Sr, Steyerberg EW. Extensions of net reclassification 
 improvement calculations to measure usefulness of new biomarkers. Stat Med. 2011;30(1):11-21

Inoue E (2018). nricens: NRI for Risk Prediction Models with Time to Event and Binary 
 Response Data. R package version 1.6, <https://CRAN.R-project.org/package=nricens>.
}
\author{
Martijn Heymans, 2023
}
