% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sp3d.R
\name{plot_sp3d}
\alias{plot_sp3d}
\title{Plot and mapping spatio-temporal trends.}
\usage{
plot_sp3d(object, data, time_var, time_index, addmain = TRUE, addint = TRUE)
}
\arguments{
\item{object}{object returned from \code{\link{pspatfit}}}

\item{data}{sf object.}

\item{time_var}{name of the temporal variable in data.}

\item{time_index}{vector of time points to plot.}

\item{addmain}{Add f1_main and f2_main plots in psanova case.}

\item{addint}{Add f12_int in psanova case.}
}
\value{
plots and maps of the spatial trends
}
\description{
Make plots and maps of the spatio-temporal trends 
  in 3d of the objects fitted with \code{\link{pspatfit}} function.
}
\examples{

library(pspatreg)
library(sf)
data(unemp_it, package = "pspatreg")
lwsp_it <- spdep::mat2listw(Wsp_it)
unemp_it_sf <- st_as_sf(dplyr::left_join(
                               unemp_it, map_it,  
                        by = c("prov" = "COD_PRO")))
######## FORMULA of the model
form3d_psanova_restr <- unrate ~ partrate + agri + cons +
                        pspl(serv, nknots = 15) + 
                        pspl(empgrowth, nknots = 20) +
                        pspt(long, lat, year, 
                             nknots = c(18, 18, 8),
                             psanova = TRUE, 
                             nest_sp1 = c(1, 2, 3), 
                             nest_sp2 = c(1, 2, 3),
                             nest_time = c(1, 2, 2),
                             f1t = FALSE, f2t = FALSE)

\donttest{
####### FIT the model
sp3danova <- pspatfit(form3d_psanova_restr, 
                      data = unemp_it_sf)
summary(sp3danova)                          

###### Plot spatio-temporal trends for different years
plot_sp3d(sp3danova, data = unemp_it_sf, 
          time_var = "year", 
          time_index = c(1996, 2005, 2019),
          addmain = FALSE, addint = FALSE)
###### Plot of spatio-temporal trend, main effects 
######      and interaction effect for a year
plot_sp3d(sp3danova, data = unemp_it_sf, 
          time_var = "year", 
          time_index = c(2019),
          addmain = TRUE, addint = TRUE)
          
#### Plot of temporal trend for each province
plot_sptime(sp3danova, 
            data = unemp_it, 
            time_var = "year", 
            reg_var = "prov") 
}
             
}
\references{
\itemize{ 
  \item Lee, D. and Durban, M. (2011). P-Spline ANOVA Type Interaction 
    Models for Spatio-Temporal Smoothing. \emph{Statistical Modelling}, 
    (11), 49-69. <doi:10.1177/1471082X1001100104>
    
  \item Eilers, P. and Marx, B. (2021). \emph{Practical Smoothing. 
  The Joys of P-Splines}. Cambridge University Press.
    
  \item Fahrmeir, L.; Kneib, T.;  Lang, S.; and Marx, B. (2021). 
    \emph{Regression. Models, Methods and Applications (2nd Ed.)}.
    Springer.
        
  \item Wood, S.N. (2017). \emph{Generalized Additive Models. 
  An Introduction with \code{R}} (second edition). CRC Press, Boca Raton.
 }
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr Maria Durban \tab
  \email{mdurban@est-econ.uc3m.es} \cr Gonzalo Espana-Heredia \tab
  \email{gehllanza@gmail.com} \cr 
}
}
