% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_ps.R
\name{rwe_ps}
\alias{rwe_ps}
\title{Get propensity scores}
\usage{
rwe_ps(
  data,
  ps_fml = NULL,
  v_covs = "V1",
  v_grp = "Group",
  cur_grp_level = 1,
  v_arm = NULL,
  trt_arm_level = 1,
  nstrata = 5,
  ...
)
}
\arguments{
\item{data}{Dataframe with group assignment and covariates}

\item{ps_fml}{Propensity score formula. If null, all covariates will be
included in the PS model in a linear form.}

\item{v_covs}{Vector of column names corresponding to covariates}

\item{v_grp}{Column name corresponding to group assignment}

\item{cur_grp_level}{Group level for the current study. Default 1.}

\item{v_arm}{Column name corresponding treatment vs. control. Ignored for
single arm studies. two-arm randomized studies.}

\item{trt_arm_level}{Arm level for the treatment arm. Ignored for single-arm
studies.}

\item{nstrata}{Number of PS strata to be created}

\item{...}{Parameters to get propensity scores. \itemize{
\item{ps_method}{\code{logistic} forlogistic regression or
\code{randomforest} for randomforest) \item{...}{Parameters for
\code{randomForest}}} }}
}
\value{
A class \code{RWE_DWITHPS} list with items:

\itemize{
\item{data}{Original data with column \code{_ps_} for estimated PS scores
and \code{_strata_} for PS stratum added}
\item{ps_fml}{PS formula for estimated PS scores}
\item{nstrata}{Number of strata}
}
}
\description{
Calculate propensity scores using logistic regression or random forest model
}
\examples{

rwe_ps(ex_dta, v_covs = paste("V", 1:7, sep = ""), v_grp = "Group",
       cur_grp_level = "current")

}
