"iclust.diagram" <- 
function(ic,labels=NULL,short=FALSE,digits=2,cex=NULL,min.size=NULL,e.size=1, main="ICLUST diagram") {

 

clusters <- ic$results  #the main table from ICLUST 
num <- nrow(clusters)
num.var <- num+1
if(is.null(cex)) cex <- min(16/num.var,1)


    if (is.null(labels)) {
    var.labels <- rownames(ic$loadings)} else {var.labels=labels}
    if (short) {var.labels <- paste("V",1:num.var,sep="")} 
    if(is.null(var.labels)) {var.labels <- paste("V",1:num.var,sep="")} 

#fixed <- fix.names(ic,var.labels)
#clusters <- fixed$ic$results
 max.len <- max(nchar((var.labels)))

length.labels <- max(max.len* .15 * cex,.25*cex)
##

nc <- length(ic$size)
nvar <- sum(ic$size)
last <- dim(clusters)[1]
max.size <- max(ic$size)

limx <- c(-length.labels,nvar+2)
limy <-  c(0,nvar+1)
if(nvar < 12) e.size <- e.size * .7   #this is a kludge to make small problems look better


if(is.null(min.size)) min.size <- .1 * nvar
plot(0,type="n",xlim=limx,ylim=limy,frame.plot=FALSE,axes=FALSE,ylab="",xlab="",main=main)

top <- num.var
done <- 0
if (nc==1) {head <- num
           size <- num.var
           y.loc <- clusters[head,"size2"]
	       down(clusters,head,size,y.loc,old.head= NULL,old.loc=NULL,min.size=min.size,e.size=e.size,digits=digits,cex=cex,limx=limx,limy=limy)
	       } else {
#the multiple cluster case           
for(clust in 1:nc) {
    size <- ic$size[clust]
	if (substr(names(ic$size[clust]),1,1)=="C") {
	
	head <- which(rownames(clusters)==names(ic$size[clust]))
	
	cluster <- clusters[head,]
	 y.loc <- clusters[head,"size2"] + done
    down(clusters,head,size,y.loc,old.head= NULL,old.loc=NULL,min.size=min.size,e.size=e.size,digits=digits,cex=cex,limx=limx,limy=limy) } 
	done <- done + size 
} 
}}

 fix.names <- function(ic,var.labels) {
 	var.names <- ic$results[,c(1:2)]
	max.len <- 0
	vn <- dim(var.names)[1]
	for(i in 1:vn) {
   		vname <- sub("V","",var.names[i,1])
 		suppressWarnings(vname <- as.numeric(vname) )
 		if(!is.na(vname) & (vname < 1)) vname <- NA
  		if(!is.na(vname)) {var.names[i,1] <- var.labels[vname] 
  		if(max.len < nchar(var.labels[vname])) max.len <- nchar(var.labels[vname]) }
   		vname <- sub("V","",var.names[i,2])
  		suppressWarnings(vname <- as.numeric(vname) )
  		if(!is.na(vname) & (vname < 1)) vname <- NA
 		 if(!is.na(vname)) {var.names[i,2] <- var.labels[vname] 
  		if(max.len < nchar(var.labels[vname])) max.len <- nchar(var.labels[vname]) }
  					}
  	ic$results[,c(1:2)] <- var.names
  return(list(ic=ic,max.len=max.len))
  }


    
 "dia.cluster" <- 
 function(x, y = NULL, cluster, link=NULL, digits=2,cex = cex,e.size=.6,xlim=c(0,1),ylim=c(0,1),small=FALSE, ...) {
   
	if(!small) {
	 text(x,y, rownames(cluster),pos=3,cex=cex)
	 text(x,y, substitute(list(alpha) == list(a),list(a=round(cluster[1,"alpha"],digits))),cex=cex) 
	text(x,y, substitute(list(beta) == list(b), list(b=round(cluster[1,"beta"],digits))),cex=cex,pos=1) } else { text(x,y, rownames(cluster),cex=cex) }
     vert <- cex*.3
     xs <- dia.ellipse1(x,y,xlim=xlim,ylim=ylim,e.size=e.size,...)
     left <- c(x-xs,y)
     right <- c(x+xs,y)
     top <- c(x,y+xs)
     bottom <- c(x,y-xs)
     center <- c(x,y)
    dia.cluster <- list(left=left,right=right,top=top,bottom=bottom,center=center,link=link,radius=xs)
     }
  
     
  #down is a recursive function that draws the complete cluster structure
  
   "down" <- 
   function(clusters,head,x,y,old.head = NULL,old.loc=NULL,digits,cex,limx,limy,min.size=1,e.size=.6,...) {

           shift <-2
           size <- clusters[head,"size"]
		   cluster <- clusters[head,]
		   if(is.null(old.loc)) {link <- NULL} else {link <- old.head}   #remember the cluster that spawned this cluster
           if(size > min.size) {c.loc <- dia.cluster(head+shift,y,cluster,link=link,digits=digits,cex=cex,e.size=e.size) } else {c.loc <- dia.cluster(head+2,y,cluster,link=link,digits=digits,cex=cex,e.size=e.size*.6,small=TRUE)}

           if(!is.null(old.loc)) { 
           						if(old.loc$top[2] < c.loc$top[2]) {labels <- round(clusters[c.loc$link,"r1"],digits) } else { labels <- round(clusters[c.loc$link,"r2"],digits)}
        						if(old.loc$left[1] < c.loc$right[1]) {
        											if(old.loc$left[2] < c.loc$right[2]) { 
                                          				dia.arrow(old.loc,c.loc,labels=labels,cex=cex)} else {
                                          dia.arrow(old.loc,c.loc,labels=labels,cex=cex)}} else {
          					 dia.arrow(old.loc,c.loc,labels=labels,cex=cex)}}
                size1 <- clusters[head,"size1"]
                size2 <- clusters[head,"size2"]
                                                                
               if(size1==1) {
                v.loc <-  dia.rect(0,y+.5,clusters[head,1],xlim=limx,ylim=limy,cex=cex,...)

                dia.arrow(c.loc,v.loc$right,round(cluster["r1"],digits),cex=cex)
                  } else {
                    
               		head1 <- which(rownames(clusters)== clusters[head,1]) 
               		cluster <- clusters[head1,]   #get ready to go down the tree

               		y.shift <- clusters[head1,"size2"]
              		down(clusters,head1,x,y+y.shift,old.head=head,old.loc = c.loc,min.size=min.size,e.size=e.size,digits=digits,cex=cex,limx=limx,limy=limy,...) 
              		} 
              		 
              		if(size2==1) {

              			v.loc <- dia.rect(0,y-.5,clusters[head,2],xlim=limx,ylim=limy,cex=cex,...)

              			dia.arrow(c.loc,v.loc$right,labels = round(clusters[head,"r2"],digits),cex=cex)

              			 } else {
              			 old.head <- head
               			head <- which(rownames(clusters)== clusters[head,2]) 
               			cluster <- clusters[head,]
               			y.shift <- clusters[head,"size1"]
               			down(clusters,head,x,y-y.shift,old.head=old.head,old.loc = c.loc,min.size=min.size,e.size=e.size,digits=digits,cex=cex,limx=limx,limy=limy,...)
               			
              					 } 
             }
