% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDataDF.R
\name{addDataDF}
\alias{addDataDF}
\title{addDataDF}
\usage{
addDataDF(dat, RT = NULL, Error = NULL)
}
\arguments{
\item{dat}{DataFrame created from createDF}

\item{RT}{Parameters for the call to rtDist function}

\item{Error}{Parameters for the call to errDist function}
}
\value{
DataFrame with RT and Error columns
}
\description{
Add simulated ex-gaussian reaction-time (RT) data and
binary error (Error = 1, Correct = 0) data to dataframe. This function
can be used to create simulated dataframes.
}
\examples{
library(psychReport)
# Example 1: default dataframe
dat <- createDF()
dat <- addDataDF(dat)
hist(dat$RT, 100)
table(dat$Error)

# Example 2: defined overall RT parameters
dat <- createDF(nVP = 50, nTrl = 50,
                design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat, RT = c(500, 150, 100))
boxplot(dat$RT ~ dat$Comp)
table(dat$Comp, dat$Error)

# Example 3: defined RT + Error parameters across conditions
dat <- createDF(nVP = 50, nTrl = 50,
                design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list(list(c("Comp:comp"), vals = c(500, 80, 100)),
                           list(c("Comp:incomp"), vals = c(550, 80, 140))),
                 Error = list(list(c("Comp:comp"), vals = c(5)),
                              list(c("Comp:incomp"), vals = c(10))))
boxplot(dat$RT ~ dat$Comp)
table(dat$Comp, dat$Error)

# Example 4:
# create dataframe with defined RT + Error parameters across different conditions
dat <- createDF(nVP = 50, nTrl = 50,
                design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
                 RT = list(list(c("Comp:comp"), vals = c(500, 150, 150)),
                           list(c("Comp:incomp"), vals = c(550, 150, 100))),
                 Error = list(list(c("Comp:comp"), vals = c(5, 4, 2, 2, 1)),
                            list(c("Comp:incomp"), vals = c(25, 8, 5, 2, 2))))
boxplot(dat$RT ~ dat$Comp)
table(dat$Comp, dat$Error)

}
