% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_funnel}
\alias{plot_funnel}
\title{Create funnel plots}
\usage{
plot_funnel(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, show_filtered = FALSE)
}
\arguments{
\item{ma_obj}{Meta-analysis object.}

\item{analyses}{Which analyses to extract? Can be either \code{"all"} to extract references for all meta-analyses in the object (default) or a list containing one or more of the following arguments:
\itemize{
\item{construct}{A list or vector of construct names to search for.}
\item{construct_pair}{A list of vectors of construct pairs to search for (e.g., \code{list(c("Construct A", "Construct B"), c("Construct A", "Construct C"))}).}
\item{pair_id}{A list or vector of numeric construct Pair IDs.}
\item{analysis_id}{A list or vector of analysis IDs (combinations of moderator levels).}
\item{k_min}{A numeric value specifying the minimum \code{k} for extracted meta-analyses.}
\item{N_min}{A numeric value specifying the minimum \code{N} for extracted meta-analyses.}
}}

\item{match}{Should extracted meta-analyses match all (default) or any of the criteria given in \code{analyses}?}

\item{case_sensitive}{Logical scalar that determines whether character values supplied in \code{analyses} should be treated as case sensitive (\code{TRUE}, default) or not (\code{FALSE}).}

\item{show_filtered}{Logical scalar that determines whether the meta-analysis object given in the output should be the modified input object (\code{FALSE}, default) or the filtered object (\code{TRUE}).}
}
\value{
A list of funnel plots.
}
\description{
Create funnel plots
}
\examples{
ma_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name, sample_id = sample_id,
               moderators = moderator, data = data_r_meas_multi,
               clean_artifacts = FALSE, impute_artifacts = FALSE)
plot_funnel(ma_obj = ma_obj, analyses = list(pair_id = 1, analysis_id = 1))
plot_funnel(ma_obj = ma_obj, analyses = list(pair_id = 2))
plot_funnel(ma_obj = ma_obj, analyses = list(pair_id = 1, analysis_id = 1), show_filtered = TRUE)
plot_funnel(ma_obj = ma_obj$construct_pairs[[1]])
}
