% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{reshape_mat2dat}
\alias{reshape_mat2dat}
\title{Extract a long-format correlation database from a correlation matrix and its supporting vectors/matrices of variable information}
\usage{
reshape_mat2dat(var_names, cor_data, common_data = NULL, unique_data = NULL,
  diag_label = NULL, lower_tri = TRUE, data = NULL)
}
\arguments{
\item{var_names}{Vector (or scalar column name to match with \code{data}) containing variable names.}

\item{cor_data}{Square matrix (or vector of column names to match with \code{data}) containing correlations among variables.}

\item{common_data}{Vector or matrix (or vector of column names to match with \code{data}) of data common to both X and Y variables (e.g., sample size, study-wise moderators).}

\item{unique_data}{Vector or matrix (or vector of column names to match with \code{data}) of data unique to X and Y variables (e.g., mean, SD, reliability).}

\item{diag_label}{Optional name to attribute to values extracted from the diagonal of the matrix (if NULL, no values are extracted from the diagonal).}

\item{lower_tri}{Logical scalar that identifies whether the correlations are in the lower triangle (\code{TRUE}) or in the upper triangle \code{FALSE} of the matrix.}

\item{data}{Matrix, dataframe, or tibble containing study data (when present, column names of \code{data} will be matched to column names provided as other arguments).}
}
\value{
Long-format dataframe of correlation data, variable names, and supporting information
}
\description{
This function is designed to extract data from a correlation matrix that is in the format commonly published in journals, with leading columns of construct names and descriptive statistics
being listed along with correlation data.
}
\examples{
## Create a hypothetical matrix of data from a small study:
mat <- data.frame(var_names = c("X", "Y", "Z"),
                  n = c(100, 100, 100),
                  mean = c(4, 5, 3),
                  sd = c(2.4, 2.6, 2),
                  rel = c(.8, .7, .85),
                  reshape_vec2mat(cov = c(.3, .4, .5)))

## Arguments can be provided as quoted characters or as the unquoted names of data's columns:
reshape_mat2dat(var_names = var_names,
               cor_data = c("Var1", "Var2", "Var3"),
               common_data = "n",
               unique_data = c("mean", "sd", "rel"),
               data = mat)

## Arguments can also provided as raw vectors, matrices, dataframes, etc. without a data argument:
reshape_mat2dat(var_names = mat[,1],
               cor_data = mat[,6:8],
               common_data = mat[,2],
               unique_data = mat[,3:5])

## If data is not null, arguments can be a mix of matrix/dataframe/vector and column-name arguments
reshape_mat2dat(var_names = mat[,1],
               cor_data = mat[,6:8],
               common_data = "n",
               unique_data = c("mean", "sd", "rel"),
               data = mat)
}
\author{
Jack W. Kostal
}
