% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_wrappers.R
\name{organize_moderators}
\alias{organize_moderators}
\title{Organization of moderator data for use in meta-analyses}
\usage{
organize_moderators(
  cat_moderator_matrix,
  es_data,
  construct_x = NULL,
  construct_y = NULL,
  construct_order = NULL,
  moderator_levels = NULL,
  moderator_type = "hierarchical",
  cat_moderator_names = NULL,
  ...
)
}
\arguments{
\item{cat_moderator_matrix}{Matrix (or vector) of categorical moderator variables.}

\item{es_data}{Matrix of effect-size data to be used in meta-analyses.}

\item{construct_x}{Vector of construct names for construct X.}

\item{construct_y}{Vector of construct names for construct Y.}

\item{construct_order}{The order in which constructs are to be arranged.}

\item{moderator_levels}{List containing the factor levels of categorical moderator variables.}

\item{moderator_type}{Type of moderator analysis: "none" means that no moderators are to be used, "simple" means that moderators are to be examined one at a time,
"hierarchical" means that all possible combinations and subsets of moderators are to be examined.}

\item{cat_moderator_names}{Vector of names for the variables in cat_moderator_matrix.}

\item{...}{Further arguments.}
}
\value{
List containing (1) the full matrix of moderators and effect-size data for use in meta-analyses and (2) the names of the moderator variables.
}
\description{
Organization of moderator data for use in meta-analyses
}
\keyword{internal}
