% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_artifacts.R
\name{estimate_q_dist}
\alias{estimate_q_dist}
\title{Estimate descriptive statistics of square-root reliabilities}
\usage{
estimate_q_dist(mean_rel, var_rel)
}
\arguments{
\item{mean_rel}{Mean reliability value.}

\item{var_rel}{Variance of reliability values.}
}
\value{
The estimated mean and variance of a distribution of square-root reliability values.
}
\description{
\loadmathjax
Estimate descriptive statistics of square-root reliabilities from descriptive statistics of reliabilities via Taylor series approximation
}
\details{
\mjdeqn{var_{q_{X}}=\frac{var_{\rho_{XX}}}{4q_{X}^{2}}}{var_rel / (4 * mean_q^2)}
}
\examples{
estimate_q_dist(mean_rel = .8, var_rel = .15)
}
