% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_factors.R
\name{n_factors}
\alias{n_factors}
\title{Find Optimal Factor Number.}
\usage{
n_factors(df, rotate = "varimax", fm = "minres", n_max = 8)
}
\arguments{
\item{df}{The dataframe}

\item{rotate}{What rotation to use c("none", "varimax", "oblimin","promax")}

\item{fm}{Factoring method: "pa" for Principal Axis Factor Analysis,
"minres" (default) for minimum residual (OLS) factoring, "mle" for
Maximum Likelihood FA and "pc" for Principal Components}

\item{n_max}{How many factors to test.}
}
\value{
output
}
\description{
Find optimal factor number using various solutions.
}
\examples{
df <- dplyr::select_if(attitude, is.numeric)
results <- psycho::n_factors(df)

summary(results)
plot(results)

# See details on methods
psycho::values(results)$methods

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
