% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_model.stanreg.R
\name{find_best_model.stanreg}
\alias{find_best_model.stanreg}
\title{Returns the best combination of predictors based on LOO cross-validation indices.}
\usage{
\method{find_best_model}{stanreg}(fit, interaction = TRUE,
  fixed = NULL, K = 10, k_treshold = NULL, ...)
}
\arguments{
\item{fit}{A stanreg object.}

\item{interaction}{Include interaction term.}

\item{fixed}{Additional formula part to add at the beginning of
each formula}

\item{K}{For kfold, the number of subsets of equal (if possible) size into
which the data will be randomly partitioned for performing K-fold
cross-validation. The model is refit K times, each time leaving out one of
the K subsets. If K is equal to the total number of observations in the data
then K-fold cross-validation is equivalent to exact leave-one-out
cross-validation.}

\item{k_treshold}{Threshold for flagging estimates of the Pareto shape
parameters k estimated by loo.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
list containing all combinations.
}
\description{
Returns the best combination of predictors based on LOO cross-validation indices.
}
\examples{
\dontrun{
library(psycho)
library(rstanarm)

data <- standardize(attitude)
fit <- rstanarm::stan_glm(rating ~ advance + privileges, data = data)

best <- find_best_model(fit)
best_formula <- best$formula
best$table

# To deactivate Kfold evaluation
best <- find_best_model(fit, K = 0)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
