% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpe.R
\name{mpe}
\alias{mpe}
\title{Compute Maximum Probability of Effect (MPE).}
\usage{
mpe(posterior)
}
\arguments{
\item{posterior}{Posterior Distribution.}
}
\value{
list containing the MPE and its values.
}
\description{
Compute the Maximum Probability of Effect (MPE), i.e., the proportion of posterior distribution that is of the same sign as the median. In other words, it corresponds to the maximum probability that the effect is different from 0 in the median’s direction.
}
\examples{
library(psycho)
library(rstanarm)

fit <- rstanarm::stan_glm(rating ~ advance, data = attitude)
posterior <- psycho::analyze(fit)$values$effects$advance$posterior
mpe <- psycho::mpe(posterior)
print(mpe$MPE)
print(mpe$values)
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
