% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{overlap}
\alias{overlap}
\title{Overlap of Two Empirical Distributions.}
\usage{
overlap(x, y, method = "trapezoid")
}
\arguments{
\item{x}{A vector of values from a probability distribution (e.g., posterior probabilities from MCMC sampling).}

\item{y}{Scalar between 0 and 1, indicating the mass within the credible interval that is to be estimated.}

\item{method}{Method of AUC computation. Can be "trapezoid" (default), "step" or "spline".}
}
\description{
A method to calculate the overlap coefficient of two kernel density estimates (a measure of similarity between two samples).
}
\examples{
library(psycho)

x <- rnorm(100, 1, 0.5)
y <- rnorm(100, 0, 1)
overlap(x, y)
}
\author{
S. Venne
}
