% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTDewPointFromVapPres}
\alias{GetTDewPointFromVapPres}
\title{Return dew-point temperature given dry-bulb temperature and vapor pressure.}
\usage{
GetTDewPointFromVapPres(TDryBulb, VapPres)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{VapPres}{A numeric vector of partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return dew-point temperature given dry-bulb temperature and vapor pressure.
}
\note{
\itemize{
 \item The dew point temperature is solved by inverting the equation giving water vapor pressure
       at saturation from temperature rather than using the regressions provided
       by ASHRAE (eqn. 37 and 38), which are much less accurate and have a
       narrower range of validity.
 \item The Newton-Raphson (NR) method is used on the logarithm of water vapour
       pressure as a function of temperature, which is a very smooth function.
 \item Convergence is usually achieved in 3 to 5 iterations.
 \item TDryBulb is not really needed here, just used for convenience.
}
}
\examples{
SetUnitSystem("IP")
GetTDewPointFromVapPres(70:80, seq(0.0149, 0.0249, 0.001))

SetUnitSystem("SI")
GetTDewPointFromVapPres(70:80, 12581:12591)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn. 5 and 6
}
