% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ansur}
\alias{ansur}
\title{Anthropometric data from US Army Personnel}
\format{
A data frame with 6068 observations from 9 variables.
\describe{
\item{subjectid}{Unique ID of the person}
\item{gender}{Binary variable indicating the subject's sex: \code{male} or \code{female}.}
\item{height}{Height in centimeters.}
\item{weight}{Weight in kilograms.}
\item{handedness}{Categorical variable indicating if the person is left, or right handed, or both.}
\item{age}{Age in years}
\item{race}{Race, with categories like \code{white}, \code{black}, \code{hispanic}.}
\item{height_tercile}{The tercile of the person's height.}
\item{age_tercile}{The tercile of the person's weight.}
}
}
\source{
This data is a transformed version of data sets obtained the \href{https://www.openlab.psu.edu/ansur2/}{Anthropometric Survey of US Army Personnel (ANSUR 2 or ANSUR II)}.
}
\usage{
ansur
}
\description{
Data on the height, weight, handedness from men and women of different ages and different races.
}
\keyword{datasets}
