% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive-utils.R
\name{describe}
\alias{describe}
\title{Calculate descriptive statistics}
\usage{
describe(data, by = NULL, ...)
}
\arguments{
\item{data}{A data frame}

\item{by}{A grouping variable. If included, the \code{data} will be grouped by the values of the
\code{by} variable before the summary statistics are applied.}

\item{...}{Arguments of functions applied to variables, e.g. \code{avg = mean(x)}.}
}
\value{
A tibble data frame with each row providing descriptive statistics
for selected variables for each value of the grouping \code{by} variable.
}
\description{
This function is a lightweight wrapper to \code{dplyr}'s \code{summarize} function.
It can be used to calculate any descriptive or summary statistic for any
variable in the data set. Optionally, a \code{by} grouping variable can be used,
and then the summary statistics are calculated for each subgroup defined by
the different values of the \code{by} variable.
}
\examples{
describe(faithfulfaces, avg = mean(faithful), stdev = sd(faithful))
describe(faithfulfaces, by = face_sex, avg = mean(faithful), stdev = sd(faithful))

}
