% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cdc15}
\alias{cdc15}
\title{Microarray time series experiment for yeast cell cycle from cdc15 experiment}
\format{Matrix with 6178 rows and 24 columns.
Some missing data.
Rows and columns are labelled.
- attr(*, "dimnames")=List of 2
..$ : chr [1:6178] "YAL001C" "YAL002W" "YAL003W" "YAL004W" ...
..$ : chr [1:24] "cdc15.10" "cdc15.30" "cdc15.50" "cdc15.70" ...}
\source{
The data is extracted from the ExpressionSet of 
the R package \code{yeastCC}.
}
\usage{
data(cdc15)
}
\description{
6,178 yeast genes expression measures (log-ratios) with 
series length 24 from the cdc15 experiment.
}
\examples{
data(cdc15)
qqnorm(colMeans(cdc15, na.rm=TRUE))
qqnorm(rowMeans(cdc15, na.rm=TRUE))
}
\references{
Spellman, P. T., Sherlock, G., Zhang, M. Q., Iyer, 
V. R., Anders, K., Eisen, M. B., ... & Futcher, B. (1998). 
Comprehensive identification of cell cycle-regulated genes of 
the yeast Saccharomyces cerevisiae by microarray hybridization. 
Molecular biology of the cell, 9(12), 3273-3297.

Dudoit S (2016). yeastCC: Spellman et al. (1998) and 
Pramila/Breeden (2006) yeast cell cycle microarray data. 
R package version 1.12.0.
}
\keyword{datasets}

