% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cdc28}
\alias{cdc28}
\title{Microarray time series experiment for yeast cell cycle from cdc28 experiment}
\format{Matrix with 6178 rows and 17 columns.
Some missing data.
Rows and columns are labelled.
- attr(*, "dimnames")=List of 2
..$ : chr [1:6178] "YAL001C" "YAL002W" "YAL003W" "YAL004W" ...
..$ : chr [1:17] "cdc28.0" "cdc28.10" "cdc28.20" "cdc28.30" ...}
\source{
The data is extracted from the ExpressionSet of 
the R package \code{yeastCC}.
}
\usage{
data(cdc28)
}
\description{
6,178 yeast genes expression measures (log-ratios) with series 
length 17 from the cdc28 experiment.
}
\examples{
data(cdc28)
qqnorm(colMeans(cdc28, na.rm=TRUE))
qqnorm(rowMeans(cdc28, na.rm=TRUE))
}
\references{
Spellman, P. T., Sherlock, G., Zhang, M. Q., Iyer, V. R.,
 Anders, K., Eisen, M. B., ... & Futcher, B. (1998). 
 Comprehensive identification of cell cycle-regulated genes of 
 the yeast Saccharomyces cerevisiae by microarray hybridization. 
 Molecular biology of the cell, 9(12), 3273-3297.

Dudoit S (2016). yeastCC: Spellman et al. (1998) and 
Pramila/Breeden (2006) yeast cell cycle microarray data. 
R package version 1.12.0.
}
\keyword{datasets}

